// java

package edu.washington.cac.calendar.data;

import java.io.*;
import java.sql.*;

import edu.washington.cac.calendar.data.Event;

public class Parse {
    private static final String EOF = "%%%%%KKKK";

    private static String readToken(StreamTokenizer st) throws IOException {
	st.nextToken();
	String value;

	if (st.ttype == StreamTokenizer.TT_WORD) {
	    value = st.sval;
	} else if (st.ttype == StreamTokenizer.TT_EOF) {
	    value = EOF;
	} else if (st.ttype == '|' || st.ttype == StreamTokenizer.TT_EOL) {
	    value = null;
	} else {
	    throw new RuntimeException("wrong token type " + st.ttype);
	}

	if (value != null && !value.equals(EOF)) {
	    st.nextToken();

	    if (st.ttype != '|' && st.ttype != StreamTokenizer.TT_EOL) {
	        throw new RuntimeException("not eol token or | " + st.ttype);
	    }
	}

	return value;
    }

    private static int readInt(StreamTokenizer st) throws IOException {
	String s = readToken(st);

	return new Integer(s).intValue();
    }

    private static java.sql.Date readDate(StreamTokenizer st)
      throws IOException
    {
	String s = readToken(st);

	if (s != null) {
	    return java.sql.Date.valueOf(s);
	} else {
	    return null;
	}
    }

    private static java.sql.Time readTime(StreamTokenizer st)
      throws IOException
    {
	String s = readToken(st);

	if (s != null) {
	    return java.sql.Time.valueOf(s);
	} else {
	    return null;
	}
    }

    private static int fixId(int id) {
	if (id < 1 || id > 110) {
	    throw new RuntimeException("bad id " + id);
	} else if (id > 3) {
	    return id + 150;
	} else {
	    return id;
	}
    }

/*
eventid|lastmod|seq|public|created|startdate|starttime|enddate|endtime|shortdesc|longdesc|link|status|locationid|sponsorid|creator|cost
28|20000823143218|1|F|2000-02-24 15:10:51|2000-02-25|11:30:00|2000-02-25|13:00:00|Lunch with Sandy||0|F|1|1|ellenj|
*/
    private static void readLine(StreamTokenizer st)
      throws IOException, SQLException, CaldataException
    {
	String dummy;

	dummy = readToken(st);
	dummy = readToken(st);
	dummy = readToken(st);
	dummy = readToken(st);
	Date startdate = readDate(st);
	Time starttime = readTime(st);
	Date enddate = readDate(st);
	Time endtime = readTime(st);
	String shortdesc = readToken(st);
	dummy = readToken(st);
	String link = readToken(st);

	if (link != null && link.equals("0")) {
	    link = null;
	}

	dummy = readToken(st);
	int locationid = fixId(readInt(st));
	int sponsorid = fixId(readInt(st));
	User creator = new User(readToken(st));
	dummy = readToken(st);

System.err.println("startdate " + startdate);
System.err.println("starttime " + starttime);
System.err.println("enddate " + enddate);
System.err.println("endtime " + endtime);
System.err.println("shortdesc " + shortdesc);
System.err.println("link " + link);
System.err.println("locationid " + locationid);
System.err.println("sponsorid " + sponsorid);
System.err.println("creator " + creator.getNameDB());
	Event e = new Event(0, shortdesc, null, startdate, starttime,
                            enddate, endtime, false, link, creator, null,
                            NoRecurrence.NO_RECUR, locationid, sponsorid,
                            0,
                            new Timestamp(new java.util.Date().getTime()),
                            new Timestamp(new java.util.Date().getTime()));
	e.add(creator);
    }

    public static void main(String[] args)
      throws IOException, SQLException, CaldataException
    {
	FileReader fr = new FileReader(args[0]);
	StreamTokenizer st = new StreamTokenizer(fr);
	st.resetSyntax();
	st.wordChars('\u0000', '\u00FF');
	st.ordinaryChar('|');
	st.ordinaryChar('\n');
	st.ordinaryChar('\r');
	st.eolIsSignificant(true);
	int lines = 0;
	String dummy;

	while ((dummy = readToken(st)) != EOF) {
	    System.err.println(lines++);
	    readLine(st);
	}
    }
}
