// java

package edu.washington.cac.calendar.data;

/**
  Recurrence information for an event that doesn't recur.

  @author Greg Barnes
  @version 1.0
 */
public class NoRecurrence extends Recurrence
{
  /** The singleton instance of this class */
  public static final Recurrence NO_RECUR = new NoRecurrence();

  /** Create a new instance.  Should not be called outside this class
   */
  private NoRecurrence() {
    super(Recurrence.NO_MASTER);
  }

  /** 
    Is this a master recurrence?
    @return Is this a master recurrence?
   */
  public boolean isMaster() 
  {
    return false;
  }

  /** 
    Is this a recurring recurrence?
    @return Is this a recurring recurrence?
   */
  public boolean recurs() 
  {
    return false;
  }

  /**
    Not allowed
    @exception IllegalStateException always thrown
   */
  public void setMasterId() throws IllegalStateException
  {
    throw new IllegalStateException("Cannot set master id for non-recurrence");
  }
}
