// java

package edu.washington.cac.calendar.data;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/**
  Recurrence information for an event that is the master event for a 
  recurrence.

  @author Greg Barnes
  @version 1.1
 */
public class MasterRecurrence extends Recurrence
{
  /** All known instances of the recurrence */
  private SortedSet instances = new TreeSet();

  /**
    Create a new instance
    @param id Id of the master event in the recurrence
   */
  public MasterRecurrence(int id)
  {
    super(id);
  }

  /** 
    Is this a master recurrence?
    @return Is this a master recurrence?
   */
  public boolean isMaster() 
  {
    return true;
  }

  /** 
    Is this a recurring recurrence?
    @return Is this a recurring recurrence?
   */
  public boolean recurs() 
  {
    return true;
  }

  /** 
    Add an instance to the set of instances
    @param e Instance to add
   */
  public void addInstance(Event e)
  {
    instances.add(e);
  }

  /** 
    Get the set of instances of this event
    @return the set of instances of this event
   */
  public Iterator getInstances()
  {
    return this.instances.iterator();
  }

  /**
    Get The number of known instances of the event
    @return The number of known instances of the event
   */
  public int knownInstances()
  {
    return this.instances.size();
  }
}
