// java

package edu.washington.cac.calendar.data;

import java.sql.SQLException;

import edu.washington.cac.calendar.db.Caldata;

/** The set of Locations associated with a user
  @author Greg Barnes
  @version 1.2
 */
public class Locations extends Cache implements CacheI
{
  /** Initialize the set for a given user 
     @param user The user
     @param load Load all locations on initialization?
     @exception SQLException if we can't load the set from the database
     @exception ItemException if the set contains bad data
    */
  public Locations(User user, boolean load) 
    throws SQLException, ItemException 
  {
    super(user, load);
  }

  /** Initialize the set for a given user, without loading it
     @param user The user
    */
  public Locations(User user) 
  {
    super(user);
  }

  /** Initialize the set for a guest, without loading it */
  public Locations() 
  {
    this(new User());
  }

  /**
    Fill up the cache
    @exception SQLException if we can't load the set from the database
    @exception ItemException if the set contains bad data
   */
  protected void doLoadAll() throws SQLException, ItemException
  {
    getCaldata().loadLocations(user, this);
  }

  /**
    Add an item to the cache
    @param c The item to add
    @exception ItemAccessException If the item can't be added to the cache
   */
  public void localAdd(CalendarObject c) throws ItemAccessException
  {
    super.localAdd( c );
  }

  /** 
      Get the location in the set with the given id
        
      @param locationID Unique ID of the location
      @return the location in the set with the given id
      @exception NoSuchItemException if the location does not exist
    */
  public Location getLocation(int locationID) throws NoSuchItemException
  {
    return (Location) get(locationID);
  }

  /**
    Load a single location into the cache
    @param id Id of the item to load
    @exception SQLException If there's a problem accessing the database
    @exception CaldataException If there's a problem with the data in the db
    @exception NoSuchItemException If the item does not exist
    @exception ItemAccessException If the item can't be added to the cache
   */
  protected void loadOne(int id)
      throws SQLException, CaldataException, NoSuchItemException,
             ItemAccessException
  {
    getCaldata().loadOneLocation(id, this);
  }
}
