// java

package edu.washington.cac.calendar.data;

import java.sql.SQLException;

import edu.washington.cac.calendar.db.Caldata;

/** 
  A set of keywords

  @author Greg Barnes
  @version 2.0
 */
public class Keywords extends Cache implements CacheI
{
  /** Create a set of keywords for a particular user
    @param user User in question
    @param load Load the keywords from the database?
    @exception SQLException if we can't load the set from the database
    @exception ItemException if the database contains bad data
   */
  public Keywords(User user, boolean load) 
      throws SQLException, ItemException
  {
    super(user, load);
  }

  /** Create a set of keywords for a particular user, without loading it
    @param user User in question
   */
  public Keywords(User user) 
  {
    super(user);
  }

  /** Create a set of keywords for the guest, without loading it
   */
  public Keywords() 
  {
    this(new User());
  }

  /**
    Fill up the cache
    @exception SQLException If there's a problem with the database
    @exception ItemException if the database contains bad data
   */
  protected void doLoadAll() throws SQLException, ItemException
  {
    getCaldata().loadKeywords(user, this);
  }

  /**
    get a keyword with a given id
    
    @param keywordId the id of the keyword
    @return the keyword in question
    @exception NoSuchItemException if the keyword does not exists
   */
  public Keyword getKeyword(int keywordId) throws NoSuchItemException
  {
    return (Keyword) get(keywordId);
  }

  /**
    Load a single keyword into the cache
    @param id Id of the item to load
    @exception SQLException If there's a problem accessing the database
    @exception CaldataException If there's a problem with the data in the db
    @exception NoSuchItemException If the item does not exist
    @exception ItemAccessException If the item can't be added to the cache
   */
  protected void loadOne(int id)
      throws SQLException, CaldataException, NoSuchItemException,
             ItemAccessException
  {
    getCaldata().loadOneKeyword(id, this);
  }
}
