// java

package edu.washington.cac.calendar.data;

/**
  Recurrence information for an event that recurs, but is not the master
  instance of the recurrence.

  The id of the master instance is used when adding public eventrefs 
  to a user's personal calendar, and when removing a recurring event.

  @author Greg Barnes
  @version 1.0
 */
public class InstanceRecurrence extends Recurrence
{
  /** Create a new instance 
    @param masterId Id of the master
   */
  public InstanceRecurrence(int masterId)
  {
    super(masterId);
  }

  /** 
    Is this a master recurrence?
    @return Is this a master recurrence?
   */
  public boolean isMaster() 
  {
    return false;
  }

  /** 
    Is this a recurring recurrence?
    @return Is this a recurring recurrence?
   */
  public boolean recurs() 
  {
    return true;
  }
}
