package edu.washington.cac.calendar.data;

import java.sql.SQLException;

//import edu.washington.cac.calendar.CalParameter;
import edu.washington.cac.calendar.db.Caldata;

/**
  a reference to a public event for a particular user.

  @author slh, Greg Barnes
  @version 1.2
 */
public class EventRef extends EntityRef
{
  /** the default purpose ('E' for 'explicitly added') */
  private static final char DEFAULT_PURPOSE = 'E';

  /** A one-character code for the 'purpose' of the eventref */
  private char purpose = DEFAULT_PURPOSE;

  /**
   Create an EventRef for a user
   @param id id of the event
   @param user the user
   @param purpose A simple code explaining why this eventref exists
   */
  public EventRef(int id, User user, char purpose)
  {
    super(id, user);
    this.purpose = purpose;
  }

  /**
   Create an EventRef for a user
   @param id id of the event
   @param user the user
   */
  public EventRef(int id, User user)
  {
    this(id, user, DEFAULT_PURPOSE);
  }

  /**
   Create an EventRef for a user
   @param cp Http Parameters, presumably including an eventid
   @param user the user
   *//*
  public EventRef(CalParameter cp, User user)
  {
    this(cp.getEventID(), user);
  }*/

  /**
    Get the purpose of this reference
    @return the purpose of this reference
   */
  public char getPurpose()
  {
    return this.purpose;
  }

  /**
    Add event reference to db.
    @return Whether the add changed one row in the database
    @exception SQLException If there's a database error
   */
  public boolean add() throws SQLException
  {
//    this.log.println("adding ref of event #" + getId() + " for user " +
//                     getUser().getName());
    return getCaldata().addEventRef(this) == 1;
  }

  /**
    Remove event reference from the db
    @exception SQLException If there's a database error
   */
  public void delete() throws SQLException
  {
//   this.log.println("deleting ref of event #" + getId() + " for user " +
//                     getUser().getName());
    getCaldata().deleteEventRef(this);
  }

  /**
    Does this reference represent an individual entity?
    @return does this reference represent an individual entity?
   */
  public boolean isSingleEntity()
  {
    return true;
  }
}
