// java

package edu.washington.cac.calendar.data;

import java.sql.SQLException;

//import edu.washington.cac.calendar.CalLogFactory;
//import edu.washington.cac.calendar.CalParameter;
import edu.washington.cac.calendar.db.Caldata;

/**
  An object that holds a reference for a user to an entity not owned by the
  user

  @author Greg Barnes
  @version 1.0
  */
public abstract class EntityRef extends DBObject
{
  /** Internal db id of the entity */
  private int id;

  /** the user */
  private User user;

  /**
   Create an EntityRef for a user
   @param id id of the entity
   @param user the user
   */
  public EntityRef(int id, User user)
  {
//    super(new CalLogFactory().create(user.getName()));
    super();
    this.id = id;
    this.user = user;
  }

  /** Get the entity's db id
    @return the entity's db id
   */
  public int getId()
  {
    return this.id;
  }

  /** Get the user
    @return the user
   */
  public User getUser()
  {
    return this.user;
  }

  /**
    Add the reference to the database
    @return Whether the add changed one row in the database
    @exception SQLException If there's a database error
   */
  public abstract boolean add() throws SQLException;

  /**
    Remove the reference from the db
    @exception SQLException If there's a database error
   */
  public abstract void delete() throws SQLException;

  /**
    Does this reference represent an individual entity?
    @return does this reference represent an individual entity?
   */
  public abstract boolean isSingleEntity();
}
