// java

package edu.washington.cac.calendar.data;

import java.sql.SQLException;
import java.util.Iterator;

import edu.washington.cac.calendar.db.Caldata;

/**
  An interface that can be used for an object that can either be a Cache
  or something that acts like it.
  @author Greg Barnes
  @version 1.0
 */
/* So far, this is only used indirectly, to make EventsI work */
public interface CacheI
{
  /**
    @return The number of items in the Cache
   */
  public int size();

  /**
    @return All the items in the cache
   */
  public Iterator elements();

  /**
    Add an item to the cache
    @param c Item to add
    @exception SQLException if there is a database problem
    @exception ItemAccessException if the item can't be added
   */
  public void add(CalendarObject c) throws SQLException, ItemAccessException;

  /**
    Add an item to the cache
    @param c Item to add
    @param saveToDB Save to database as well?
    @exception SQLException if there's a database problem
    @exception ItemAccessException if the item can't be added
   */
  public void add(CalendarObject c, boolean saveToDB)
      throws SQLException, ItemAccessException;

  /**
    delete an item from the Cache

    @param c the item to delete
    @exception ItemException if there's a problem with c
    @exception SQLException if there is a problem with the database
   */
  public void delete(CalendarObject c) throws SQLException, ItemException;

  /**
    replace an item in the Cache

    @param c the item to replace (the current item with the same id
      as c will be replaced with c)
    @exception SQLException if there is a problem with the database
    @exception ItemException if there's a problem with the item specified
   */
  public void replace(CalendarObject c)
      throws SQLException, ItemException;

  /**
    get an item from the Cache

    @param id ID of the item
    @return The CalendarObject with the same id
    @exception NoSuchItemException if no item exists with that id
   */
  public CalendarObject get(int id) throws NoSuchItemException;

  /**
    @return If the key refers to an object in the cache
    @param o key to check
   */
  public boolean containsKey(Object o);

  /**
    @return all the elements in the cache, in sorted order
   */
  public Iterator sortedElements();

  /**
    @return Are all the elements in the cache loaded?
   */
  public boolean isLoaded();
}
