// java

package edu.washington.cac.calendar.data;

/**
  A set of access rights for a calendar object (see RFC 2447's VCAR component)
  @author Greg Barnes
  @version 1.0
 */
public abstract class AccessRights
{
  /** Object access rights pertain to */
  CalendarObject c;

  AccessRights(CalendarObject c)
  {
    this.c = c;
  }

  /**
    Is a user the creator of the object?
    @param user the user to test
    @return Is the user the creator of the object?
   */
  protected boolean isCreator(User user)
  {
    return c.getCreator().equals(user);
  }

  /** Can a user read (search for, include in their cache) the object?
    @param user User to test
    @return Can the user read (search for, include in their cache) the object?
   */
  abstract boolean canBeReadBy(User user);

  /** Can a user modify the object?
    @param user User to test
    @return Can the user modify the object?
   */
  abstract boolean canBeModifiedBy(User user);

  /** Can a user create the object?
    @param user User to test
    @return Can the user create the object?
   */
  abstract boolean canBeCreatedBy(User user);

  /** Can a user delete the object?
    @param user User to test
    @return Can the user delete the object?
   */
  abstract boolean canBeDeletedBy(User user);
}
