<%@ taglib uri='struts-bean' prefix='bean' %>
<%@ taglib uri='struts-logic' prefix='logic' %>

<bean:define id="eventFmt" name="eventFormatter" scope="session" />
<bean:define id="event" name="eventFmt" property="event" />
<%-- Output a single event --%>
  <event>
    <start><%-- start date and time --%>
      <bean:define id="date" name="eventFmt"
                   property="startCalendar"
                   toScope="session" />
      <jsp:include page="/docs/emitDate.jsp" />
    </start>
    <end><%-- end date and time --%>
      <bean:define id="date" name="eventFmt"
                   property="endCalendar"
                   toScope="session" />
      <jsp:include page="/docs/emitDate.jsp" />
    </end>
    <id><bean:write name="event" property="id"/></id><%--
      Value: integer - event id --%>
    <shortdesc><bean:write name="event" property="shortdesc"/></shortdesc><%--
      Value: string - short description, typically used for the event title  --%>
    <link><bean:write name="event" property="link"/></link><%--
      Value: URI - link associated with the event --%>
    <public><bean:write name="event" property="public"/></public>
    <editable><bean:write name="event" property="editable"/></editable><%--
      Value: true,false - true if user can edit (and delete) event, false otherwise --%>
    <kind><bean:write name="event" property="kind"/></kind><%--
      Value: 0 - actual event entry
             1 - 'added event' from a reference
             2 - from a subscription --%>
    <recurring><bean:write name="event" property="recurring"/></recurring><%--
      Value: true,false - true if the event is recurring --%>
    <logic:present  name="event" property="location">
      <bean:define id="location" name="event" property="location"/>
      <location>
        <address><bean:write name="location" property="address"/></address><%--
          Value: string - physical address of the location --%>
        <link><bean:write name="location" property="link"/></link><%--
            Value: URI - link to a web address for the location --%>
        <logic:present name="detailView" scope="request"><%--
          Only output these attributes if we are in detailed mode... --%>
          <id><bean:write name="location" property="id"/></id><%--
            Value: integer - location id --%>
          <subaddress><bean:write name="location" property="subaddress"/></subaddress><%--
            Value: string - more address information --%>
          <creator><bean:write name="location" property="creator.name"/></creator><%--
            Value: string - location creator id --%>
        </logic:present>
      </location>
    </logic:present>
    <logic:notPresent  name="event" property="location">
      <location>
        <address></address>
        <logic:present name="detailView" scope="request"><%--
          Only output these attributes if we are in detailed mode... --%>
          <id></id><%--
            Value: integer - location id --%>
          <subaddress></subaddress><%--
            Value: string - more address information --%>
          <link></link><%--
            Value: URI - link to a web address for the location --%>
          <creator></creator><%--
            Value: string - location creator id --%>
        </logic:present>
      </location>
    </logic:notPresent>
    <keywords>
      <logic:present name="event" property="keywords">
        <logic:iterate id="keyword" name="event" property="keywords">
          <keyword>
            <id><bean:write name="keyword" property="id"/></id><%--
              Value: integer - keyword id --%>
            <value><bean:write name="keyword" property="word"/></value><%--
              Value: string - the keyword value --%>
            <logic:present name="detailView" scope="request"><%--
              Only output these attributes if we are in detailed mode... --%>
              <longdesc><bean:write name="keyword" property="description"/></longdesc><%--
                Value: string - long description of keyword --%>
              <creator><bean:write name="keyword" property="creator.name"/></creator><%--
                Value: string - keyword creator id --%>
            </logic:present>
          </keyword>
        </logic:iterate>
      </logic:present>
    </keywords>
    <logic:present name="detailView" scope="request"><%--
      Only output these attributes if we are in detailed mode... --%>
      <longdesc><bean:write name="event" property="longdesc"/></longdesc><%--
          Value: string - long description of the event.  Limited to 500 characters. --%>
      <%--<longdesc1><bean:write name="event" property="longdesc1"/></longdesc1>
          Event's other long description (not currently used) --%>
      <cost><bean:write name="event" property="cost"/></cost><%--
          Value: string - cost information --%>
      <locationid><bean:write name="event" property="locationid"/></locationid><%--
          Value: integer - location id --%>
      <%-- <seq><bean:write name="event" property="seq"/></seq>
          Sequence number for the event (not currently used) --%>

      <logic:present name="event" property="sponsor">
        <bean:define id="sponsor" name="event" property="sponsor"/>
        <sponsor>
          <id><bean:write name="sponsor" property="id"/></id><%--
            Value: integer - sponsor id --%>
          <name><bean:write name="sponsor" property="name"/></name><%--
            Value: string - sponsor's name --%>
          <phone><bean:write name="sponsor" property="phone"/></phone><%--
            Value (example): x7777 - sponsor's phone number --%>
          <email><bean:write name="sponsor" property="email"/></email><%--
            Value (example): nobody@nowhere.edu - sponsor's email address --%>
          <link><bean:write name="sponsor" property="link"/></link><%--
            Value: URI - link to sponsor web page --%>
        </sponsor>
      </logic:present>
    </logic:present>
  </event>
