/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webclient;

import edu.rpi.cct.uwcal.calsvci.CalSvcI;
import edu.washington.cac.calfacade.shared.EventVO;
import edu.washington.cac.calfacade.shared.LocationVO;

import javax.servlet.http.HttpServletRequest;

/**
 * Action to delete an event
 * <p>Request parameters:<ul>
 *      <li>  eventId</li>.
 * </ul>
 * <p>Forwards to:<ul>
 *      <li>"doNothing"    for guest mode.</li>
 *      <li>"success"      deleted ok.</li>
 * </ul>
 * <p>Errors:<ul>
 *      <li>org.ucal.calendar.message.deleted.events - when
 *            event is deleted - 1 parameter: count</li>
 *      <li>org.ucal.calendar.message.deleted.locations - when
 *            location is deleted - 1 parameter: count</li>
 *      <li>org.ucal.calendar.message.nosuchevent</li>
 * </ul>
 */
public class UWCalDelEventAction extends UWUserCalAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalActionForm form) throws Throwable {
    if (form.getGuest()) {
      return "doNothing";
    }

    int id = form.getEventId();

    if (id < 0) {
      // Do nothing
      return "doNothing";
    }

    CalSvcI svci = form.getCalSvcI();

    EventVO e = svci.getEvent(id);

    if (e == null) {
      msg.emit("org.ucal.calendar.message.nosuchevent", id);
      return "doNothing";
    }

    LocationVO loc = e.getLocation();

    if (!svci.deleteEvent(id)) {
      msg.emit("org.ucal.calendar.message.nosuchevent", id);
      return "doNothing";
    }

    if ((loc != null) &&
        (!svci.checkLocationRefs(loc.getId())) &&
        (svci.deleteLocation(loc.getId()))) {
      msg.emit("org.ucal.calendar.message.deleted.locations", 1);
    }

    msg.emit("org.ucal.calendar.message.deleted.events", 1);
    svci.touch();
    form.refreshIsNeeded();

    return "success";
  }
}
