/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webclient;

import edu.rpi.cct.uwcal.common.UWCalDefs;

import edu.washington.cac.calfacade.shared.EventVO;
import edu.washington.cac.calfacade.shared.MyCalendarVO;

import javax.servlet.http.HttpServletRequest;

/**
 * Action to add an event to a personal calendar.
 * <p>Request parameters<ul>
 *      <li>"eventId" id of event.</li>
 * </ul>
 * <p>Forwards to:<ul>
 *      <li>"doNothing"    when request seems wrong.</li>
 *      <li>"notPersonal"  when this is not a personal calendar.</li>
 *      <li>"error"        some form of (db) error.</li>
 *      <li>"success"      added ok.</li>
 * </ul>
 */
public class UWCalAddEventRefAction extends UWUserCalAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalActionForm form) throws Throwable {
    if (form.getGuest()) {
      return "doNothing";
    }

    int eventId = form.getEventId();

    if ((eventId < 0) ||
        (!form.getCalSvcI().addEventRef(eventId))) {
      err.emit("org.ucal.calendar.error.nosuchevent", eventId);

      return "doNothing";
    }

    msg.emit("org.ucal.calendar.message.added.eventrefs", 1);

    EventVO ev = form.getCalSvcI().getEvent(eventId);
    MyCalendarVO mc = new MyCalendarVO(ev.getStartdate(), null);
    UWCalGoToAction.gotoDateView(this, form,
                  mc.getDateDigits(),
                  UWCalDefs.dayView,
                  debug);

    form.refreshIsNeeded();

    return "success";
  }
}
