/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webclient;

import edu.rpi.cct.uwcal.calsvci.TimeDateComponents;
import edu.washington.cac.calfacade.shared.CheckData;
import edu.washington.cac.calfacade.shared.EventVO;
import edu.washington.cac.calfacade.shared.LocationVO;

import javax.servlet.http.HttpServletRequest;

/**
 * Action to add an Event.
 * <p>No specific request parameters. Form should contain an initialised
 * EventVO object.
 * <p>Forwards to:<ul>
 *      <li>"error"        some form of (db) error.</li>
 *      <li>"success"      added ok.</li>
 * </ul>
 */
public class UWCalAddEventAction extends UWUserCalAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalActionForm form) throws Throwable {
    if (form.getGuest()) {
      // Just ignore this
      return "doNothing";
    }

    EventVO ev = form.getNewEvent();

    if (ev == null) {
      return "doNothing";
    }

    ev.setShortdesc(form.checkNull(ev.getShortdesc()));
    ev.setLongdesc(form.checkNull(ev.getLongdesc()));

    if (ev.getShortdesc() == null) {
      err.emit("org.ucal.calendar.error.notitle");
      return "doNothing";
    }

    TimeDateComponents sdate = form.getEventStartDate();
    TimeDateComponents edate = form.getEventEndDate();

    StringBuffer sb = new StringBuffer();

    if (!CheckData.checkDateTimes(sdate.getDate(),
                                  sdate.getTime(),
                                  edate.getDate(),
                                  edate.getTime(),
                                  sb)) {
      err.emit("org.ucal.calendar.error.baddates", sb);
      return "doNothing";
    }

    ev.setStartdate(sdate.getDate());
    ev.setStarttime(sdate.getTime());

    ev.setEnddate(edate.getDate());
    ev.setEndtime(edate.getTime());

    /** We might also need to add a location - for private events we don't
     * require a location
     */
    if (form.getLocationId() != EventVO.DefaultLocationId) {
      LocationVO l = form.getCalSvcI().getLocation(form.getLocationId());

      if (l != null) {
        ev.setLocationid(l.getId());
        ev.setLocation(l);
      }
    }

    if (ev.getLocationid() == EventVO.DefaultLocationId) {
      LocationVO l = form.getNewLocation();

      if ((l != null) && (l.getAddress() != null))  {
        ev.setLocationid(form.getCalSvcI().addLocation(l));
        ev.setLocation(l);

        msg.emit("org.ucal.calendar.message.added.locations", 1);
      }
    }

    form.getCalSvcI().addEvent(ev);

    form.resetNewEvent();
    form.resetNewLocation();
    form.resetEventStartDate();
    form.resetEventEndDate();

    msg.emit("org.ucal.calendar.message.added.events", 1);

    form.refreshIsNeeded();

    return "success";
  }
}
