/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.admin;

import edu.rpi.cct.uwcal.calsvci.CalSvcI;
import edu.rpi.cct.uwcal.webcommon.UWCalActionFormBase;
import edu.rpi.cct.uwcal.webcommon.UWCalSession;

import edu.washington.cac.calfacade.shared.KeywordAttrsVO;
import edu.washington.cac.calfacade.shared.KeywordVO;
import edu.washington.cac.calfacade.shared.UserAuth;

import javax.servlet.http.HttpServletRequest;

/** This action adds or modifies keywords.
 *
 * @author Mike Douglass   douglm@rpi.edu
 */
public class PEKeyWdAction extends PEAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param sess      UWCalSession calendar session object
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalSession sess,
                         PEActionForm form) throws Throwable {
    CalSvcI svci = form.getCalSvcI();

    /** Check access
     */
    if (!form.getUserAuth().isContentAdminUser()) {
      return "noAccess";
    }

    /** =================================================================
     *                   Initial keyword actions
     *  ================================================================= */

    String reqpar = request.getParameter("initAddKeyword");

    if (reqpar != null) {
      /** Set the objects to null so we get new ones.
       */
      form.initFields();

      return "addKeyword";
    }

    reqpar = request.getParameter("listUpdateKeywords");

    if (reqpar != null) {
      return "listKeywords";
    }

    /** =================================================================
     *                   Keyword update actions
     *  ================================================================= */

    reqpar = request.getParameter("deleteKeyword");
    if (reqpar != null) {
      return deleteKeyword(form, svci);
    }

    reqpar = request.getParameter("addKeyword");

    if (reqpar != null) {
      if (!form.validateKeyword()) {
        return "retryAdd";
      }

      updateKeyword(form, svci, true);
      return "done";
    }

    reqpar = request.getParameter("action");

    if (String.valueOf(reqpar).equals("fetch")) {
      /** User requested a keyword from the list. Retrieve it, embed it in
       * the form so we can display the page
       */
      int id = form.getKeyword().getId();

      KeywordVO keyword = svci.getPublicKeyword(id);

      if (debug) {
        if (keyword == null) {
          logIt("No keyword with id " + id);
        } else {
          logIt("Retrieved keyword " + keyword.getId());
        }
      }

      form.setKeyword(keyword);
      if (keyword == null) {
        err.emit("org.ucal.calendar.pubevents.error.nosuchkeyword",
                 id);
        return "notFound";
      }

      form.setKeyAlertFlag(svci.getKeyAlert(id));

      return "updateKeyword";
    }

    /** We are just updating from the current form values.
     */
    if (!form.validateKeyword()) {
      return "retryMod";
    }

    return updateKeyword(form, svci, false);
  }

  private String deleteKeyword(PEActionForm form,
                               CalSvcI svci) throws Throwable {
    int id = form.getKeyword().getId();

    /** Only allow delete if not in use
     */
    if (svci.checkKeywordRefs(id)) {
      msg.emit("org.ucal.calendar.pubevents.message.keyword.referenced");
      return "keywordInUse";
    }

    /* Remove from preferences */
    UserAuth ua = form.retrieveUserAuth();

    ua.removeKeyword(null, id);

    if (!svci.deleteKeyword(id)) {
      err.emit("org.ucal.calendar.pubevents.error.nosuchkeyword", id);
      return "noSuchKeyword";
    }

    msg.emit("org.ucal.calendar.pubevents.message.keyword.deleted");
    svci.touch();

    return "done";
  }

  private String updateKeyword(PEActionForm form,
                               CalSvcI svci,
                               boolean add) throws Throwable {
    /* if a keyword with the same name, phone, e-mail, link, and creator exist
       in keywords table then retrieve its keywordid, otherwise add this
       keyword to the database and then retrieve its keywordid.
     */

    KeywordVO k = form.getKeyword();
/*
    if (!add && (sp.getId() <= KeywordVO.maxReservedId)) {
      // claim it doesn't exist
      err.emit("org.ucal.calendar.pubevents.error.nosuchkeyword",
               sp.getId());
      return "noSuchKeyword";
    }
*/
    if (add) {
      svci.ensureKeywordExists(k);
    } else {
      svci.replaceKeyword(k);
    }

    svci.setKeyAlert(k.getId(), form.getKeyAlertFlag());
    svci.touch();

    if (add) {
      msg.emit("org.ucal.calendar.pubevents.message.keyword.added");
    } else {
      msg.emit("org.ucal.calendar.pubevents.message.keyword.updated");
    }

    return "done";
  }
}

