/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.admin;

import edu.rpi.cct.uwcal.webcommon.UWCalActionFormBase;
import edu.rpi.cct.uwcal.webcommon.UWCalSession;

import edu.washington.cac.calfacade.shared.AuthUserVO;

import javax.servlet.http.HttpServletRequest;

/** This action manages authorised users.
 *
 * @author Mike Douglass   douglm@rpi.edu
 */
public class PEAuthAction extends PEAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param sess      UWCalSession calendar session object
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalSession sess,
                         PEActionForm form) throws Throwable {
    /** Check access
     */
    if (!form.getUserAuth().isSuperUser()) {
      return "noAccess";
    }

    /** =================================================================
     *                   Initial auth actions
     *  ================================================================= */

    String reqpar = request.getParameter("listUpdateAuth");

    if (reqpar != null) {
      return "listUpdateAuth";
    }

    /** =================================================================
     *                   Auth update actions
     *  ================================================================= */

    reqpar = request.getParameter("removeAuth");
    if (reqpar != null) {
      return removeAuth(form);
    }

    reqpar = request.getParameter("fetch");

    if (reqpar != null) {
      /** User requested a user from the list or by entering the id.
       */
      String userid = form.getAuthUserId();

      AuthUserVO au = form.getCalSvcI().getUserAuth().getUser(userid);

      if (debug) {
        logIt("Retrieved auth user " + au.getUserid() +
              " with type " + au.getUsertype());
      }

      form.setAuthUser(au);

      return "updateAuth";
    }

    reqpar = request.getParameter("modAuthUser");

    if (reqpar != null) {
      /** We are just updating from the current form values.
       */
      if (!form.validateAuthUser()) {
        return "retryMod";
      }

      return updateAuth(form);
    }

    return "success";
  }

  private String removeAuth(PEActionForm form) throws Throwable {
    form.getCalSvcI().getUserAuth().removeAuth(form.getAuthUser());

    msg.emit("org.ucal.calendar.pubevents.message.authuser.removed");

    return "done";
  }

  private String updateAuth(PEActionForm form) throws Throwable {
    form.getCalSvcI().getUserAuth().updateUser(form.getAuthUser());

    msg.emit("org.ucal.calendar.pubevents.message.authuser.updated");

    return "done";
  }
}

