/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.admin;

import edu.rpi.cct.uwcal.webcommon.UWCalActionFormBase;
import edu.rpi.cct.uwcal.webcommon.UWCalSession;

import javax.servlet.http.HttpServletRequest;
import java.util.StringTokenizer;

/** Little action to add initial set of calendars
 *
 * @author Mike Douglass   douglm@rpi.edu
 */
public class PEAddCalsAction extends PEAbstractAction {
  /** This is the routine which does the work.
   *
   * @param request   Needed to locate session
   * @param sess      UWCalSession calendar session object
   * @param form      Action form
   * @return String   forward name
   */
  public String doAction(HttpServletRequest request,
                         UWCalSession sess,
                         PEActionForm form) throws Throwable {
    if (!form.getUserAuth().isSuperUser()) {
      return "noAccess";
    }

    /** =================================================================
     *                   Initial calendars actions
     *  ================================================================= */

    String reqpar = request.getParameter("initAddCalendars");

    if (reqpar != null) {
      return "addCalendars";
    }

    /** =================================================================
     *                   Calendars update actions
     *  ================================================================= */

    String caldefs = form.getCalendarDefs();

    if (caldefs == null) {
      return "done";
    }

    StringTokenizer st = new StringTokenizer(caldefs, "\n\r\f", false);

    while (st.hasMoreTokens()) {
      String caldef = st.nextToken();

      if (caldef.startsWith("#") || (caldef.trim().length() == 0)) {
        // Skip - it's a comment or blank line
      } else {
        try {
          String s = caldef.substring(caldef.indexOf("("),
                                      caldef.lastIndexOf(")") + 1);

          form.getCalSvcI().addCalendarDef(s);
        } catch (Throwable t) {
          t.printStackTrace();
          return "error";
        }
      }
    }

    return "done";
  }
}

