<%@ taglib uri='struts-bean' prefix='bean' %>
<%@ taglib uri='struts-logic' prefix='logic' %>
<%@ taglib uri='struts-html' prefix='html' %>

<logic:equal name="peForm" property="alertEvent" value="true" >
  <h2>Alert Information</h2>
</logic:equal>

<logic:notEqual name="peForm" property="alertEvent" value="true" >
  <h2>Event Information</h2>
</logic:notEqual>

<table class="eventFormTable">
  <tr>
    <td class="fieldName">
      Title:
    </td>
    <td>
      <html:text property="event.shortdesc" size="40" />
    </td>
  </tr>
  <tr>
    <td class="fieldName">
      Start date/time:
    </td>
    <td>
      <div class="dateFields">
        <html:select property="eventStartDate.month">
         <html:options labelProperty="eventStartDate.monthLabels"
                        property="eventStartDate.monthVals"/>
        </html:select>
        <html:select property="eventStartDate.day">
          <html:options labelProperty="eventStartDate.dayLabels"
                        property="eventStartDate.dayVals"/>
        </html:select>
        <html:select property="eventStartDate.year">
          <html:options property="yearVals"/>
        </html:select>
      </div>
      <div class="timeFields">
        <html:select property="eventStartDate.hour">
          <html:options labelProperty="eventStartDate.hourLabels"
                        property="eventStartDate.hourVals"/>
        </html:select>
        <html:select property="eventStartDate.minute">
          <html:options labelProperty="eventStartDate.minuteLabels"
                        property="eventStartDate.minuteVals"/>
        </html:select>
        <logic:notEqual name="peForm" property="hour24" value="true" >
          <html:select property="eventStartDate.ampm">
            <html:options property="eventStartDate.ampmLabels"/>
          </html:select>
        </logic:notEqual>
      </div>
    </td>
  </tr>
  <tr>
    <td class="fieldName">
      End date/time:
    </td>
    <td>
      <div class="dateFields">
        <html:select property="eventEndDate.month">
          <html:options labelProperty="eventEndDate.monthLabels"
                        property="eventEndDate.monthVals"/>
        </html:select>
        <html:select property="eventEndDate.day">
          <html:options labelProperty="eventEndDate.dayLabels"
                        property="eventEndDate.dayVals"/>
        </html:select>
        <html:select property="eventEndDate.year">
          <html:options property="yearVals"/>
        </html:select>
      </div>
      <div class="timeFields">
        <html:select property="eventEndDate.hour">
          <html:options labelProperty="eventEndDate.hourLabels"
                        property="eventEndDate.hourVals"/>
        </html:select>
        <html:select property="eventEndDate.minute">
          <html:options labelProperty="eventEndDate.minuteLabels"
                        property="eventEndDate.minuteVals"/>
        </html:select>
        <logic:notEqual name="peForm" property="hour24" value="true" >
          <html:select property="eventEndDate.ampm">
            <html:options property="eventEndDate.ampmLabels"/>
          </html:select>
        </logic:notEqual>
      </div>
    </td>
  </tr>
  <%-- <tr>
    <td colspan="2" class="fieldInfo">
      (If this event has different times on different dates, enter them in
      Description field and select None for start and end time.)
    </td>
  </tr> --%>

  <%--             Category            --%>
  <logic:present name="peForm" property="preferredKeywords">
      <tr>
        <td class="fieldName">
          Category**:
        </td>
        <td>
          <html:select property="prefKeywordId">
            <html:option value="-1">
              Select preferred:
            </html:option>
            <logic:equal name="peForm" property="alertEvent" value="true" >
              <html:optionsCollection name="peForm" property="alertKeywords"
                                      label="word" value="id" />
            </logic:equal>
            <logic:notEqual name="peForm" property="alertEvent" value="true" >
              <html:optionsCollection name="peForm" property="preferredKeywords"
                                    label="word" value="id" />
            </logic:notEqual>
          </html:select>
          <logic:notEqual name="peForm" property="alertEvent" value="true" >
            Category (all):
            <html:select property="keywordId">
              <html:option value="-1">
                Select:
              </html:option>
              <html:optionsCollection name="peForm" property="publicKeywords"
                                        label="word" value="id" />
            </html:select>
            <html:link page="/setup.do?categories=yes" target="_blank">Category Definitions</html:link>
          </logic:notEqual>
        </td>
      </tr>
  </logic:present>
  <logic:notPresent name="peForm" property="preferredKeywords">
    <tr>
      <td class="fieldName">
        Category:
      </td>
      <td>
        <html:select property="keywordId">
          <html:option value="-1">
            Select:
          </html:option>
          <logic:equal name="peForm" property="alertEvent" value="true" >
            <html:optionsCollection name="peForm" property="alertKeywords"
                                    label="word" value="id" />
          </logic:equal>

          <logic:notEqual name="peForm" property="alertEvent" value="true" >
            <html:optionsCollection name="peForm" property="publicKeywords"
                                    label="word" value="id" />
          </logic:notEqual>
        </html:select>
        <html:link page="/setup.do?categories=yes" target="_blank">Category Definitions</html:link>
      </td>
    </tr>
  </logic:notPresent>

  <%--             Description            --%>
  <tr>
    <td class="fieldName">
      Description:
    </td>
    <td>
      <html:textarea property="event.longdesc" rows="8" cols="55" />
      <div class="fieldInfo">
        Enter all pertinent information, including the academic titles of
        all speakers and/or participants.
        <span class="maxCharNotice">(<bean:write name="peForm" property="maxDescriptionLength" /> characters max.)</span>
      </div>
    </td>
  </tr>
  <%--             Cost            --%>
  <tr>
    <td class="optional">
      Price:
    </td>
    <td>
      <html:text property="event.cost" size="30" />
      <span class="fieldInfo">(optional: if any, and place to purchase tickets)</span>
    </td>
  </tr>
  <%--             Url            --%>
  <tr>
    <td class="optional">
      URL:
    </td>
    <td>
      <html:text property="event.link" size="30" />
      <span class="fieldInfo">(optional: for more information about the event)</span>
    </td>
  </tr>
  <%--             Location            --%>
  <tr>
    <logic:present name="peForm" property="preferredLocations">
      <td class="fieldName">
        Location**:
      </td>
      <td>
        <html:select property="prefLocationId">
          <html:option value="-1">
            Select preferred:
          </html:option>
          <html:optionsCollection property="preferredLocations"
                                  label="address"
                                  value="id"/>
        </html:select>
        or Location (all):
        <html:select property="locationId">
          <html:option value="-1">
            Select:
          </html:option>
          <html:optionsCollection property="publicLocations"
                                  label="address"
                                  value="id"/>
        </html:select>
      </td>
    </logic:present>
    <logic:notPresent name="peForm" property="preferredLocations">
      <td class="fieldName">
        Location:
      </td>
      <td>
        <html:select property="locationId">
          <html:option value="-1">
            Select:
          </html:option>
          <html:optionsCollection property="publicLocations"
                                  label="address"
                                  value="id"/>
        </html:select>
      </td>
    </logic:notPresent>
  </tr>

  <logic:equal name="peForm" property="session.autoCreateLocations"
               value="true">
    <tr>
      <td class="fieldName" colspan="2">
        <span class="std-text"><span class="bold">or</span> add</span>
      </td>
    </tr>
    <tr>
      <td class="fieldName">
        Address:
      </td>
      <td>
        <html:text size="30" value="" property="location.address" />
        <div class="fieldInfo">
          Please include room, building, and campus (if not Seattle).
        </div>
      </td>
    </tr>
    <tr>
      <td class="optional">
        <span class="std-text">Location URL:</span>
      </td>
      <td>
        <html:text property="location.link" size="30" />
        <span class="fieldInfo">(optional: for information about the location)</span>
      </td>
    </tr>
  </logic:equal>

  <%--             Sponsor            --%>
  <tr>
    <logic:present name="peForm" property="preferredSponsors">
      <td class="fieldName">
        Contact**:
      </td>
      <td>
        <html:select property="prefSponsorId">
          <html:option value="-1">
            Select preferred:
          </html:option>
          <html:optionsCollection property="preferredSponsors"
                                  label="name"
                                  value="id"/>
        </html:select>
        or Contact (all):
        <html:select property="sponsorId">
          <html:option value="-1">
            Select:
          </html:option>
          <html:optionsCollection property="sponsors"
                                  label="name"
                                  value="id"/>
        </html:select>
      </td>
    </logic:present>
    <logic:notPresent name="peForm" property="preferredSponsors">
      <td class="fieldName">
        Contact:
      </td>
      <td>
        <html:select property="sponsorId">
          <html:option value="-1">
            Select:
          </html:option>
          <html:optionsCollection property="sponsors"
                                  label="name"
                                  value="id"/>
        </html:select>
      </td>
    </logic:notPresent>
  </tr>
  <tr>
    <td colspan="2" style="padding-top: 1em;">
      <span class="fieldInfo">
        **<strong>If "preferred values" are enabled</strong>
        by your administrator, the category, location, and contact lists will
        contain only those value you've used previously.  If you don't find the value
        you need in one of these lists, use the "all" list to the right of each
        of these fields.  The event you select from the "all" list will be added
        to your preferred list from that point on.  <strong>Note: if you don't
        find a location or contact at all, you can add a new one from the
        <html:link page="/setup.do">main menu</html:link>.</strong>
        Only administrators can create categories, however.
        To make sure you've used the
        correct category, please see the
        <html:link page="/setup.do?categories=yes" target="_blank">
          Category Definitions
        </html:link>.
      </span>
    </td>
  </tr>

  <logic:equal name="peForm" property="session.autoCreateSponsors"
               value="true">
    <tr>
      <td class="fieldName" colspan="2">
        <span class="std-text"><span class="bold">or</span> add</span>
      </td>
    </tr>
    <tr>
      <td class="fieldName">
        Contact:
      </td>
      <td>
        <html:text property="sponsor.name" size="30" />
      </td>
    </tr>
    <tr>
      <td class="fieldName">
        Contact Phone Number:
      </td>
      <td>
        <html:text property="phoneAreaCode" size="3" maxlength="3" />-
        <html:text property="phoneBegin" size="3" maxlength="3" />-
        <html:text property="phoneEnd" size="4" maxlength="4" />
      </td>
    </tr>
    <tr>
      <td class="optional">
        Contact's URL:
      </td>
      <td>
        <html:text property="sponsor.link" size="30" />
        <span class="fieldInfo">(optional)</span>
      </td>
    </tr>
    <tr>
      <td class="optional">
        Contact Email Address:
      </td>
      <td>
        <html:text property="sponsor.email" size="30" />
        <span class="fieldInfo">(optional)</span>
      </td>
    </tr>
    <tr>
      <td class="optional">
        Additional Phone Info:
      </td>
      <td>
        <html:text property="phoneExtra" size="30" />
        <span class="fieldInfo">(optional)</span>
      </td>
    </tr>
  </logic:equal>
</table>
