<%@ taglib uri='struts-bean' prefix='bean' %>
<%@ taglib uri='struts-logic' prefix='logic' %>
<%@ taglib uri='struts-html' prefix='html' %>

<% String title = "Events Calendar Management"; %>
<logic:equal name="peForm" property="userAuth.superUser" value="true" >
  <% title = "Events Calendar Administration"; %>
</logic:equal>

<jsp:include page="/docs/menuHeader.jsp">
  <jsp:param name="title" value="<%=title%>"/>
</jsp:include>

<%--  Non admin segment of the page --%>
<h2 class="menuTitle">Main Menu</h2>
<table id="mainMenuTable">
  <tr>
    <th>Events</th>
      <td>
        <html:link page="/events.do?initAddEvent=yes" >
          Add
        </html:link>
      </td>
      <td>
        <html:link page="/events.do?listUpdateEvents=yes" >
          Edit / Delete
        </html:link>
      </td>
    </td>
    <td>
      Event ID: 
      <html:form action="events.do?action=fetch">
        <html:text property="event.id" size="6" />
        <html:submit value="go" />
      </html:form>
    </td>
  </tr>
  <logic:equal name="peForm" property="userAuth.alertUser" value="true" >
    <tr>
      <th>Alerts</th>
      <td>
        <html:link page="/alerts.do?initAddAlert=yes" >
          Add
        </html:link>
      </td>
      <td>
        <html:link page="/alerts.do?listUpdateAlerts=yes" >
          Edit / Delete
        </html:link>
      </td>
    </tr>
  </logic:equal>
  <tr>
    <th>Contacts</th>
    <td>
      <html:link page="/sponsors.do?initAddSponsor=yes" >
        Add
      </html:link>
    </td>
    <td>
      <html:link page="/sponsors.do?listUpdateSponsors=yes" >
        Edit / Delete
      </html:link>
    </td>
  </tr>
  <tr>
    <th>Locations</th>
    <td>
      <html:link page="/locations.do?initAddLocation=yes" >
        Add
      </html:link>
    </td>
    <td>
      <html:link page="/locations.do?listUpdateLocations=yes" >
        Edit / Delete
      </html:link>
    </td>
  </tr>
</table>


<%--  Content admin and super user segment of the page.
     Super user will have content admin access. --%>

<logic:equal name="peForm" property="userAuth.contentAdminUser" value="true" >
  <h2 class="menuTitle">Administrator's Menu</h2>
  <table id="adminMenuTable">
    <logic:equal name="peForm" property="userAuth.superUser"
                 value="true" >
      <logic:equal name="peForm" property="adminGroupMaintOK"
                   value="true" > 
        <tr>        
          <th>Admin Groups</th>
          <td>
            <html:link page="/admingroups.do?listAdminGroups=yes" >
              List Admin Groups
            </html:link>
          </td>
        </tr>
      </logic:equal>
      <logic:equal name="peForm" property="userMaintOK" value="true" >
        <tr>
          <th>Authorised Users</th>
          <td>
            <html:form action="auth.do">
              user:&nbsp;<html:text property="authUserId" size="15" />
              <html:submit property="fetch" value="Update Auth" />
            </html:form>
          </td>
          <td>
            <html:link page="/auth.do?listUpdateAuth=yes" >
              List Authorised
            </html:link>
          </td>
        </tr>
      </logic:equal>
      <tr>
        <th>Calendars</th>
        <td>
          <html:link page="/calendars.do?initAddCalendars=yes" >
            Add (all)
          </html:link>
        </td>
      </tr>
    </logic:equal>
    <tr>
      <th>Keywords</th>
      <td>
        <html:link page="/keywords.do?initAddKeyword=yes" >
          Add
        </html:link>
      </td>
      <td>
        <html:link page="/keywords.do?listUpdateKeywords=yes" >
          Edit / Delete
        </html:link>
      </td>
    <tr>
    <%-- <tr>
      <th>Administer for:</th> 
      <td>
        <html:form action="setup.do">
          user:&nbsp;
          <html:text property="adminUserId" size="15" /><br/>
          <html:submit property="setAdminId" value="Switch User" />
        </html:form>
      </td> 
    </tr> --%>
    <tr>
      <th>Groups</th>
      <td>
        <html:link page="/admingroups.do?initSwitchGroup=yes" >
          Choose group...
        </html:link>
      </td>
    </tr>
  </table>
</logic:equal>

<jsp:include page="/docs/footer.jsp" />

