/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.servlets.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

/** Useful I/O classes for filtering etc.
 *
 * @author Mike Douglass douglm@rpi.edu.
 */
public class ByteArrayServletStream extends ServletOutputStream {
  ByteArrayOutputStream baos;

  public ByteArrayServletStream(ByteArrayOutputStream baos) {
    this.baos = baos;
  }

  public void write(int param) throws IOException {
    baos.write(param);
  }

  public void close() {
    if (baos != null) {
      try {
        baos.close();
      } catch (Exception bae) {}
    }

    try {
      super.close();
    } catch (Exception sce) {}
  }
}

