/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.servlets;

import edu.rpi.sss.util.PropertyUtil;
import edu.rpi.sss.util.PropertyUtilException;
import javax.servlet.ServletConfig;

import java.util.Enumeration;
import org.apache.log4j.Logger;

/**
 *
 * DSProperties.java
 * Names and indices of properties used by DbmdSevlet.
 * Defaults should be for the safest mode.
 *
 * Created on October 19, 1999, 4:15 PM
 *
 * @author  Mike Douglass douglm@rpi.edu
 * @version 1.0
 */
public class ServletProperties extends PropertyUtil {

  /** These will save the initial set of property names and values
      as supplied to the constructor. They are accessible through the
      prop(i) and other methods.
   */
  private String[] propertyNames;
  private String[] propertyDefaults;

  private Logger log;

  private class MyConfigurator extends PropertyUtil.Configurator {
    ServletConfig config;

    public MyConfigurator(ServletConfig config) {
      super();
      this.config = config;

      if ((log != null) && (log.isDebugEnabled())) {
        Enumeration e = config.getInitParameterNames();
        log.debug("config pars are: ");
        while (e.hasMoreElements()) {
          log.debug("  -- " + (String)e.nextElement());
        }
      }
    }

    public String get(String name) {
      String val = this.config.getInitParameter(name);
      if ((log != null) && (log.isDebugEnabled())) {
        if (val == null) {
          log.debug("config: " + name + " = null");
        } else {
          log.debug("config: " + name + " = " + val);
        }
      }
      return val;
    }
  }

  /** Creates new ServletProperties */
  public ServletProperties(String[] propertyNames,
       String[] propertyDefaults,  Logger log) throws PropertyUtilException {
    super(propertyNames, propertyDefaults);
    this.log = log;
  }

  public void setConfig(ServletConfig config) throws PropertyUtilException {
    configure(new MyConfigurator(config));
  }

  public String prop(int index) {
    return getStr(propertyNames[index]);
  }

  public void propSet(int index, String val) {
    put(propertyNames[index], val);
  }

  public int intProp(int index) throws PropertyUtilException {
    return getInt(propertyNames[index]);
  }

  public boolean boolProp(int index) throws PropertyUtilException {
    return getBool(propertyNames[index]);
  }

  public String prop(String p) {
    return getStr(p);
  }

  public void propSet(String p, String val) {
    put(p, val);
  }

  public int intProp(String p) throws PropertyUtilException {
    return getInt(p);
  }

  public boolean boolProp(String p) throws PropertyUtilException {
    return getBool(p);
  }

  public void dump(String title) {
    log.debug(title);
    Enumeration e = propertyNames();

    while (e.hasMoreElements()) {
      String name = (String)e.nextElement();
      String val = getStr(name);

      log.debug("  " + name + " = " + nullStr(val));
    }
  }

  private String nullStr(String s) {
    if (s == null) {
      return "<null>";
    }

    return s;
  }

}
