/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.servlets;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;

/**
  This provides a base class for servlets, handling properties and providing
  some useful methods.

 * @author  Mike Douglass
 * @version 1.0
 */
public class ServletBase extends HttpServlet implements Serializable {

  /** You'll want this false for any production servlet
   */
  protected boolean debugTrace = false;

  transient ServletConfig config;

  protected boolean logging = true;

  protected ServletProperties pr;
  protected ServletUtil util;

  /** The overriding class should create arrays of property names and
      initial values then call baseInit to initialize the property
      routines.
      For example
  String[] propertyNames = {
    "color",
    "shape"
  };

  String[] propertyDefaults = {
    "red",
    "rectangular"
  };
   */

  public ServletBase() {
    super();
  }

  /** Call this from the constructor of the overriding class
   */
  public void baseInit(String[] propertyNames, String[] propertyDefaults,
       boolean debugTrace) {
    this.debugTrace = debugTrace;
    util = new ServletUtil(this, Logger.getLogger(this.getClass()));
    pr = util.setProperties(propertyNames, propertyDefaults);
  }

  /** Calld by the servlet container when the servlet is started.
      This provides us with access to global parameters and is the point at
      which we can set up connections to services.
   */
  public synchronized void init(ServletConfig config)
          throws ServletException {
    super.init(config);
    this.config = config;
    util.setConfig(config);
    if (logging) log("Servlet initialized");
  }

  /** You need to override the doGet/doPost or the service methods
    public void doGet(HttpServletRequest req, HttpServletResponse res)
       throws ServletException, IOException {...}
   */

  /**
   * Property set and get methods. These may be called as part of bean serialization in
   * which case we may not have a PropertyUtil object.
   * We will presume that calling the set method changes the default value.
   */

  public boolean getLogging() {
    return logging;
  }

  public void setLogging(boolean val) {
    this.logging = val;
  }

  public void dumpConfig() {
    Logger log = Logger.getLogger(this.getClass());

    if (!log.isDebugEnabled()) {
      return;
    }

    Enumeration names = config.getInitParameterNames();

    log.debug("Initial parameters:");

    while (names.hasMoreElements()) {
      String key = (String)names.nextElement();
      String val = config.getInitParameter(key);
      log.debug("  " + key + " = " + val);
    }
  }

}
