/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.servlets;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.upload.MultipartRequestWrapper;

/** Package of small useful methods
 */
public class HttpServletUtils {
  /** Had to have this because it's subclassed.
   */
  public HttpServletUtils() throws Exception {
    throw new Exception("Dont instantiate");
  }

  /** Return the browser type for the given request. We attempt to reduce the
   *  set of browsers to a more manageable number. The returned value is one of:
   * <ul>
   * <li>opera     The opera browser</li>
   * <li>MSIE      Microsoft Internet Explorer compatible</li>
   * <li>Netscape6 Netscape 6.x</li>
   * <li>Mozilla   Mozilla</li>
   * <li>Netscape4 Netscape 4.x compatible</li>
   * <li>default   none of the above</li>
   * </ul>
   *
   * @param   request Incoming HttpServletRequest object
   * @return  String  browser type
   */
  public static String getBrowserType(HttpServletRequest request) {
    if (request == null) {
      return "default";
    }

    String userAgent = String.valueOf(
        request.getHeader("User-Agent")).toLowerCase();

    if ((userAgent.indexOf("aladdino") >= 0) ||
        (userAgent.indexOf("avantgo") >= 0) || // AvantGo service
        (userAgent.indexOf("docomo") >= 0) ||
        (userAgent.indexOf("Elaine") >= 0) || // this is the Palm
        (userAgent.indexOf("isilo") >= 0) ||
        (userAgent.indexOf("mazingo") >= 0) ||
        (userAgent.indexOf("mobipocket webcompanion") >= 0) ||
        (userAgent.indexOf("mobipocket+webcompanion") >= 0) ||
        (userAgent.indexOf("plucker") >= 0) ||
        (userAgent.indexOf("webwasher") >= 0)) {
      /**
       * The browser is a PDA
       */
      return "PDA";
    }

    if (userAgent.indexOf("opera") >= 0) {
      /**
       * Opera browser
       */
      return "Opera";
    }

    if (userAgent.indexOf("msie") >= 0) {
      /**
       * The browser is Microsoft Internet Explorer compatible
       */
      return "MSIE";
    }

    if (userAgent.indexOf("netscape6") >= 0) {
      /**
       *  The browser is Netscape 6.x
       */
      return "Netscape6";
    }

    if (userAgent.indexOf("gecko") >= 0) {
      /**
       *  The browser is Mozilla
       */
      return "Mozilla";
    }

    if ((userAgent.indexOf("mozilla/4") >= 0) &&
        (userAgent.indexOf("spoofer") == -1) &&
        (userAgent.indexOf("webtv") == -1)) {
      /**
       * The browser is Netscape 4.x compatible
       */
      return "Netscape4";
    }

    /**
     * Otherwise return a generic value
     */
    return "default";
  }

  public static String getReqLine(HttpServletRequest req) {
    StringBuffer ret = req.getRequestURL();
    String query = req.getQueryString();

    if (query != null) {
      ret.append("?").append(query);
    }

    return ret.toString();
  }

  /** Returns the String url from the request.
   *
   *  @param   request     incoming request
   *  @return  String      url from the request
   */
  public static String getUrl(HttpServletRequest request) {
    if (request instanceof MultipartRequestWrapper) {
      return ((MultipartRequestWrapper)request).getRequest().
                      getRequestURL().toString();
    }

    return request.getRequestURL().toString();
  }

  /** Returns the scheme + host + port part of the url.
   *  This allows us to link to services on the same machine.
   *  <p>For example, a URL of http://myhost.com:8080/myapp/doit.do will get a
   *  result "http://myhost.com:8080"
   */
  public static String getURLshp(HttpServletRequest request) {
    String url = getUrl(request);

    int pos = url.indexOf(request.getContextPath());

    if (pos < 0) {
      // Guess we just have to presume there is no context path
      return url;
    }

    return url.substring(0, pos);
  }

  /** Returns the scheme + host + port part of the url together with the
   *  path up to the servlet path. This allows us to append a new action to
   *  the end.
   *  <p>For example, a URL of http://myhost.com:8080/myapp/doit.do will get a
   *  result "http://myhost.com:8080/myapp"
   */
  public static String getURLPrefix(HttpServletRequest request) {
    return getURLshp(request) + getContext(request);
  }

  /** Returns the context path.
   *  <p>For example, a URL of http://myhost.com:8080/myapp/doit.do will get a
   *  result "/myapp"
   *
   * <p>Note: do we have to deal with MultipartRequestWrapper?
   */
  public static String getContext(HttpServletRequest request) {
    String context = request.getContextPath();
    if ((context == null) || (context.equals("."))) {
      context = "";
    }

    return context;
  }

  /** Return a concatenated string of all the headers
   *
   * @param   req    Incoming HttpServletRequest object
   */
  public static String getHeaders(HttpServletRequest req) {
    Enumeration en = req.getHeaderNames();
    StringBuffer sb = new StringBuffer();

    while (en.hasMoreElements()) {
      String name = (String) en.nextElement();
      sb.append(name);
      sb.append(": ");
      sb.append(req.getHeader(name));
      sb.append("\n");
    }
    return sb.toString();
  }

  /** Print all the headers
   *
   * @param   req    Incoming HttpServletRequest object
   */
  public static void dumpHeaders(HttpServletRequest req, Logger log) {
    Enumeration en = req.getHeaderNames();
    StringBuffer sb = new StringBuffer();

    while (en.hasMoreElements()) {
      String name = (String) en.nextElement();
      log.debug(name + ": " + req.getHeader(name));
    }
  }
}

