/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.servlets;

//import java.io.ByteArrayInputStream;
//import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PrintStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/** Class to implement a filter to dump all output.
 * The final configuration of this object can be carried out by overriding init
 * or preFilter.
 * <p>Based on some public example of filter code.
 */
public class DumpFilter implements Filter {
  private ServletContext ctx;
  private boolean debug = false;
  private PrintStream out;

  public void setOut(OutputStream val) {
    out = new PrintStream(val);
  }

  public void setDebug(boolean val) {
    debug = val;
  }

  public boolean getDebug() {
    return debug;
  }

  /** This will attempt to initialise from the filter configuration.
   *
   * @param filterConfig  The filter configuration
   */
  public void init(FilterConfig filterConfig) throws ServletException {
    ctx = filterConfig.getServletContext();

    debug = (boolpar(filterConfig, "debug"));

    if (boolpar(filterConfig, "dump")) {
      out = System.out;
    } else {
      out = null;
    }
  }

  private boolean boolpar(FilterConfig filterConfig, String name) {
    String temp = filterConfig.getInitParameter(name);

    if ((temp != null) && (temp.equalsIgnoreCase("true"))) {
      return true;
    }

    return false;
  }

  /** This method can be overridden to allow a subclass to set up ready for a
   *  transformation.
   *
   * @param   request    Incoming HttpServletRequest object
   */
  public void doPreFilter(HttpServletRequest request)
    throws ServletException {
  }

  public void doFilter(ServletRequest req,
                       ServletResponse response,
                       FilterChain filterChain)
         throws IOException, ServletException {
    HttpServletRequest hreq = (HttpServletRequest)req;
    final HttpServletResponse resp = (HttpServletResponse)response;

    doPreFilter(hreq);

    if (debug) {
      ctx.log("Filter with DumpFilter for " +
              HttpServletUtils.getReqLine(hreq) + " " +
              hreq.getMethod());
    }

    if (out == null) {
      if (debug) {
        ctx.log("DumpFilter: no output stream");
      }
      filterChain.doFilter(req, resp);
      return;
    }

    final CharArrayWriter caw = new CharArrayWriter();
/*
    HttpServletResponse wrappedResp = new HttpServletResponseWrapper(resp) {
      public PrintWriter getWriter() {
        return caw.getWriter();
      }

      public ServletOutputStream getOutputStream() {
        return caw.getStream();
      }

      public void setContentType(String type) {
        resp.setContentType(type);
      }
    };
*/

    PrintWriter pout = new PrintWriter(out);
    CharResponseWrapper wrappedResp =
      new CharResponseWrapper((HttpServletResponse)resp);

    filterChain.doFilter(req, wrappedResp);
/*
    char[] chars = caw.toCharArray();
    if (chars == null || (chars.length == 0)) {
      ctx.log("Dump filter: No content.");
      return;
    }*/

    pout.write("------------------------ Dump of response -------------------");
    String str = wrappedResp.toString();
    pout.write(str);
    pout.write("---------------------- End dump of response -----------------");
    pout.flush();

    resp.setContentLength(str.length());
//    resp.getOutputStream().write(str);
    resp.getWriter().write(str);
  }

  public void destroy() {
    if (debug) {
      ctx.log("Destroying filter...");
    }
  }

  /*
  private static class CharArrayServletStream extends ServletOutputStream {
    CharArrayWriter caw;

    CharArrayServletStream(CharArrayWriter caw) {
      this.caw = caw;
    }

    public void write(int param) throws IOException {
      caw.write(param);
    }
  }
*/

  public class CharResponseWrapper extends HttpServletResponseWrapper {
    private CharArrayWriter output;

    public String toString() {
      return output.toString();
    }

    public CharResponseWrapper(HttpServletResponse response) {
      super(response);
      output = new CharArrayWriter();
    }

    public PrintWriter getWriter() {
      return new PrintWriter(output);
    }

    public void flushBuffer() {
    }
  }
  /*
  private static class CharArrayPrintWriter {
    private CharArrayOutputStream baos = new CharArrayOutputStream();
    private PrintWriter pw = new PrintWriter(baos);
    private ServletOutputStream sos = new CharArrayServletStream(baos);

    public PrintWriter getWriter() {
      return pw;
    }

    public ServletOutputStream getStream() {
      return sos;
    }

    char[] toCharArray() {
      return baos.toCharArray();
    }
  }*/
}

