/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.log;

import java.io.Serializable;

/** This object allows context free error message generation.
 *  At the point messages are generated we might be called from the web
 *  world or from an application world.
 *
 * <p>Each method takes a property name as the first parameter.
 * Optional arguments follow.
 *
 * <p>The implementation is of course free to interpret the first parameter
 * any way it wants. The assumption though, is that rather than providing
 * the actual message text the pname acts as a reference.
 *
 * @author Mike Douglass douglm@rpi.edu
 * @version 1.0
 */
public interface MessageEmit extends Serializable {
  /** We define a number of message emit methods.
   */

  public void emit(String pname);

  public void emit(String pname, int num);

  /** Set the property name of the default exception message
   */
  public void setExceptionPname(String pname);

  public void emit(Throwable t);

  public void emit(String pname, Object o);

  public void emit(String pname, Object o1, Object o2);

  public void emit(String pname, Object o1, Object o2, Object o3);

  /** Indicate no messages emitted.
   */
  public void clear();

  /** Return true if any messages emitted
   */
  public boolean messagesEmitted();
}

