/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.jsp;

import javax.servlet.http.HttpSessionListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.ServletContext;

import java.util.Enumeration;
import org.apache.log4j.Logger;

/** A class to listen for session start and end. Note this may not work too
 * well in a clustered environment because the counts should be shared.
 */
public class SessionListener implements HttpSessionListener {
  private static volatile int activeSessions = 0;
  private static volatile long totalSessions = 0;
  private static boolean logActive = true;
  private static String id = "";

  /** Name of the init parameter holding our name */
  private static final String appNameInitParameter = "rpiappname";

  public SessionListener() {}

  /* Session Creation Event */
  public void sessionCreated(HttpSessionEvent se) {
    activeSessions++;
    totalSessions++;
    HttpSession session = se.getSession();
    ServletContext sc = session.getServletContext();

    if (logActive) {
      logSessionCounts(session, true);
      sc.log("========= New session(" + id +
             "): " + activeSessions + " active, " +
             totalSessions + " total. vm(used, max)=(" +
            Runtime.getRuntime().freeMemory()/(1024 * 1024) + "M, " +
            Runtime.getRuntime().totalMemory()/(1024 * 1024) + "M)");
    }

    Enumeration enum = session.getAttributeNames();

    if (false) {
      while (enum.hasMoreElements()) {
        String s = (String)enum.nextElement();
        Object o = session.getAttribute(s);

        sc.log("New session: attribute name " + s);
      }
    }
  }

  /* Session Invalidation Event */
  public void sessionDestroyed(HttpSessionEvent se) {
    if (activeSessions > 0) {
      activeSessions--;
    }
    HttpSession session = se.getSession();
    ServletContext sc = session.getServletContext();
    if (logActive) {
      logSessionCounts(session, false);
      sc.log("========= Session destroyed(" + id +
             "): " + activeSessions + " active. vm(used, max)=(" +
            Runtime.getRuntime().freeMemory()/(1024 * 1024) + "M, " +
            Runtime.getRuntime().totalMemory()/(1024 * 1024) + "M)");
    }
  }

  public static void setLogActive(boolean val) {
    logActive = val;
  }

  public static int getActiveSessions() {
    return activeSessions;
  }

  public static long getTotalSessions() {
    return totalSessions;
  }

  public static void setId(String val) {
    if (val != null) {
      id = val;
    } else {
      id = "";
    }
  }

  /** Log the session counters for applications that maintain them.
   *
   * @param sess       HttpSession for the session id
   * @param start      true for session start
   * @param sessionNum long number of session
   * @param sessions   long number of concurrent sessions
   */
  protected void logSessionCounts(HttpSession sess,
                                  boolean start) {
    Logger log = Logger.getLogger(this.getClass());
    StringBuffer sb;
    ServletContext sc = sess.getServletContext();

    String appname = sc.getInitParameter(appNameInitParameter);
    if (appname == null) {
      appname = "?";
    }

    if (start) {
      sb = new StringBuffer("SESSION-START:");
    } else {
      sb = new StringBuffer("SESSION-END:");
    }

    sb.append(getSessionId(sess));
    sb.append(":");
    sb.append(appname);
    sb.append(":");
    sb.append(activeSessions);
    sb.append(":");
    sb.append(totalSessions);
    sb.append(":");
    sb.append(Runtime.getRuntime().freeMemory()/(1024 * 1024));
    sb.append("M:");
    sb.append(Runtime.getRuntime().totalMemory()/(1024 * 1024));
    sb.append("M");

    log.info(sb.toString());
  }

  /** Get the session id for the loggers.
   *
   * @return  String    session id
   */
  private String getSessionId(HttpSession sess) {
    try {
      if (sess == null) {
        return "NO-SESSIONID";
      } else {
        return sess.getId();
      }
    } catch (Throwable t) {
      return "SESSION-ID-EXCEPTION";
    }
  }
}

