/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util.fmt;

import java.text.MessageFormat;

/**
*
* @author   Mike Douglass
* @version  1.0
*
* Make formatting easier
*/
public class FmtUtil {
  private FmtUtil() {} // No instantiation

  // Format a message consisting of a format string
  public static String fmtMsg(String fmt, String arg) {
    Object[] o = new Object[1];
    o[0] = arg;

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus two string parameters
  public static String fmtMsg(String fmt, String arg1, String arg2) {
    Object[] o = new Object[2];
    o[0] = arg1;
    o[1] = arg2;

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus three string parameters
  public static String fmtMsg(String fmt, String arg1, String arg2, String arg3) {
    Object[] o = new Object[3];
    o[0] = arg1;
    o[1] = arg2;
    o[2] = arg3;

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus one integer parameter
  public static String fmtMsg(String fmt, int arg) {
    Object[] o = new Object[1];
    o[0] = new Integer(arg);

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus two integer parameters
  public static String fmtMsg(String fmt, int arg1, int arg2) {
    Object[] o = new Object[2];
    o[0] = new Integer(arg1);
    o[1] = new Integer(arg2);

    return MessageFormat.format(fmt, o);
  }
}
