/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util;

import java.text.MessageFormat;
import java.util.Random;

/**
*
* @author   Mike Douglass
* @version  1.0
*
* A number of bitty utility routines.
*/
public class Util {
  public static boolean debugTrace; // set true to generate some output

  private Util() {} // Don't instantiate this

  // Format a message consisting of a format string
  public static String fmtMsg(String fmt, String arg) {
    Object[] o = new Object[1];
    o[0] = arg;

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus two string parameters
  public static String fmtMsg(String fmt, String arg1, String arg2) {
    Object[] o = new Object[2];
    o[0] = arg1;
    o[1] = arg2;

    return MessageFormat.format(fmt, o);
  }

  // Format a message consisting of a format string
  //  plus one integer parameter
  public static String fmtMsg(String fmt, int arg) {
    Object[] o = new Object[1];
    o[0] = new Integer(arg);

    return MessageFormat.format(fmt, o);
  }

  private static final char[] randChars = {
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
    'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

  /** Creates a string of given length where each character comes from a
   * set of values 0-9 followed by A-Z.
   *
   * @param length    returned string will be this long. Less than 1k + 1
   * @param maxVal    maximum ordinal value of characters.  If < than 0,
                      return null.  If > 35, 35 is used instead.
   * @return String   the random string
   */
  public static String makeRandomString(int length, int maxVal) {
    if (length < 0) {
      return null;
    }

    length = Math.min(length, 1025);

    if (maxVal < 0) {
      return null;
    }

    maxVal = Math.min(maxVal, 35);

    StringBuffer res = new StringBuffer();
    Random rand = new Random();

    for (int i = 0; i <= length; i++) {
      res.append(randChars[rand.nextInt(maxVal + 1)]);
    }

    return res.toString();
  }

  /** Add a string to a string array of a given maximum length. Truncates
   * the string array if required.
   *
   * New entries go at the end. old get dropped off the front.
   *
   * @param  sarray     String[] to be updated
   * @param  val        new entry
   * @param  maxEntries Number of entries we keep.
   * @return String[]   Modified sarray
   */
  public static String[] appendTextToArray(String[] sarray, String val,
                                    int maxEntries) {
    if (sarray == null) {
      if (maxEntries > 0) {
        sarray = new String[1];
        sarray[0] = val;
      }
      return sarray;
    }

    if (sarray.length > maxEntries) {
      String[] neb = new String[maxEntries];
      System.arraycopy(sarray, sarray.length - maxEntries,
                       neb, 0, maxEntries);
      sarray = neb;
      sarray[sarray.length - 1] = val;
      neb = null;
      return sarray;
    }

    if (sarray.length < maxEntries) {
      int newLen = sarray.length + 1;
      String[] neb = new String[newLen];
      System.arraycopy(sarray, 0,
                       neb, 0, sarray.length);
      sarray = neb;
      sarray[sarray.length - 1] = val;
      neb = null;

      return sarray;
    }

    if (maxEntries > 1) {
      System.arraycopy(sarray, 1,
                       sarray, 0, sarray.length - 1);
    }

    sarray[sarray.length - 1] = val;
    return sarray;
  }
}
