/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.sss.util;

import java.util.Vector;

/**
 *
 * @author  Mike Douglass
 * @version
 * DelimitedString.java
 *
 * Created on December 21, 2000, 10:01 AM 10:01 AM
 Just a convenient class to take a string separated by some delimiter string
 and break it into segments.

 NOT IMPLEMENTED: Some form of escape sequence.
 */

public class DelimitedString {
  private boolean valid = false;
  private String str = null;
  private String delimiter = null;
  private int delimiterLength = -1;
  private Vector elements = null;

  public DelimitedString(String delimiter) {
    this.delimiter = delimiter;
    this.delimiterLength = delimiter.length();
  }

  public DelimitedString(String s, String delimiter) {
    this(delimiter);
    setStr(s);
  }

  public boolean isNull() {
    return (str == null) && (elements == null);
  }

  public void setStr(String s) {
    clear();

    int pos = 0;
    int len = s.length();

    while (pos < len) {
      int temp = s.indexOf(delimiter, pos);
      if (temp < 0) {
        // No more
        addElement(s.substring(pos));
        pos = len;
      } else {
        addElement(s.substring(pos, temp));
        pos = temp + delimiterLength;
      } // if
    } // while

    str = s;
    valid = true;
  }

  public String getStr() {
    if (!valid) validate();
    return str;
  }

  public String toString() {
    return getStr();
  }

  public void clear() {
    str = null;
    if (elements != null) elements.clear();
  }

  public int size() {
    if (elements == null) return 0;
    return elements.size();
  }

  public void addElement(String el) {
    if (elements == null) elements = new Vector();
    elements.add(el);
    valid = false;
    str = null; // needs rebuild.
  }

  public void removeLastElement() throws Exception {
    if (!valid) validate();

    if (elements == null)
      throw new Exception("DelimitedString: No string defined");
    if (elements.size()== 0)
      throw new Exception("DelimitedString: Element index error");
    elements.removeElementAt(elements.size() - 1);
  }

  public String element(int i) throws Exception {
    if (!valid) validate();

    if (elements == null)
      throw new Exception("DelimitedString: No string defined");
    if ((i < 0) || (i >= elements.size()))
      throw new Exception("DelimitedString: Element index error");
    return (String)elements.elementAt(i);
  }

  public String lastElement() throws Exception {
    if (!valid) validate();

    if (elements == null)
      throw new Exception("DelimitedString: No string defined");
    return (String)elements.lastElement();
  }

  public String[] toArray() throws Exception {
    if (elements == null)
      throw new Exception("DelimitedString: No string defined");

    String[] res = new String[size()];

    return (String[])elements.toArray(res);
  }

  public void validate() {
    if (valid) return;

    if (str == null) {
      makeStr();
    } else {
      // Can this happen?
      String s = str;
      setStr(s);
    }
  }

  public void makeStr() {
    if (elements == null) return; // just leave it alone.

    str = "";
    for (int i = 0; i < elements.size(); i++) {
      if (i != 0) str += delimiter;
      str += (String)elements.elementAt(i);
    }

    valid = true;
  }
}

