/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webcommon;

import edu.rpi.cct.uwcal.calsvci.CalSvcI;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

/** Useful shared web utility routines
 *
 * @author  Mike Douglass  douglm@rpi.edu
 */
public class UWCalWebUtil {
  /** Name of the session attribute holding our session state
   */
  static final String sessStateAttr = "edu.washington.cac.uwcal.sessstate";

  /** Name of the session attribute holding our calendar interface
   */
  static final String sessCalSvcIAttr = "edu.washington.cac.uwcal.calsvci";

  /** Try to get the session state object  embedded in
   *  the current session.
   *
   * @param request  Needed to locate session
   * @return UWCalSession null on failure
   */
  public static UWCalSession getState(HttpServletRequest request) {
    HttpSession sess = request.getSession(false);

    if (sess != null) {
      Object o = sess.getAttribute(sessStateAttr);
      if ((o != null) && (o instanceof UWCalSession)) {
        return (UWCalSession)o;
      }
    } else {
      noSession();
    }

    return null;
  }

  /** Set the session state object into the current session.
   *
   * @param request  HttpServletRequest Needed to locate session
   * @param s        UWCalSession session object
   */
  public static void setState(HttpServletRequest request,
                              UWCalSession s) {
    HttpSession sess = request.getSession(false);

    if (sess != null) {
      sess.setAttribute(sessStateAttr, s);
    } else {
      noSession();
    }
  }

  /** Try to get the CalSvcI object  embedded in
   *  the current session.
   *
   * @param request  Needed to locate session
   * @return CalSvcI  null on failure
   */
  public static CalSvcI getCalSvcI(HttpServletRequest request) {
    HttpSession sess = request.getSession(false);

    if (sess != null) {
      Object o = sess.getAttribute(sessCalSvcIAttr);
      if ((o != null) && (o instanceof CalSvcI)) {
        return (CalSvcI)o;
      }
    } else {
      noSession();
    }

    return null;
  }

  /** Set the CalSvcI object into the current session.
   *
   * @param request        HttpServletRequest Needed to locate session
   * @param svci           CalSvcI object
   */
  public static void setCalSvcI(HttpServletRequest request,
                                CalSvcI svci) {
    HttpSession sess = request.getSession(false);

    if (sess != null) {
      sess.setAttribute(sessCalSvcIAttr, svci);
    } else {
      noSession();
    }
  }

  private static void noSession() {
    Logger.getLogger("edu.rpi.cct.uwcal.webcommon.UWCalWebUtil").warn(
            "No session!!!!!!!");
  }
}

