/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webcommon;

import edu.rpi.sss.util.servlets.PresentationState;

import java.io.Serializable;

/** This interface represents a session for the UWCal web interface.
 * Some user state will be retained here.
 * We also provide a number of methods which act as the interface between
 * the web world and the calendar world.
 *
 * <p>The UW web interface has session support that may not be applicable
 * to all potential users of this application. We should try to interface to
 * it through this.
 *
 * @author Mike Douglass   douglm@rpi.edu
 */
public interface UWCalSession extends Serializable {
  /** ===================================================================
   *                   Options set from application properties
   *  =================================================================== */

  /** True if we should auto-create sponsors. Some sites may wish to control
   * the creation of sponsors to enforce consistency in their use. If this
   * is true we create a sponsor as we create events. If false the sponsor
   * must already exist.
   */
  public boolean getAutoCreateSponsors();

  /** True if we should auto-delete sponsors. Some sites may wish to control
   * the deletion of sponsors to enforce consistency in their use. If this
   * is true we delete a sponsor when it becomes unused.
   */
  public boolean getAutoDeleteSponsors();

  /** True if we should auto-create locations. Some sites may wish to control
   * the creation of locations to enforce consistency in their use. If this
   * is true we create a location as we create events. If false the location
   * must already exist.
   */
  public boolean getAutoCreateLocations();

  /** True if we should auto-delete locations. Some sites may wish to control
   * the deletion of locations to enforce consistency in their use. If this
   * is true we delete a location when it becomes unused.
   */
  public boolean getAutoDeleteLocations();

  /** ===================================================================
   *                     Property methods
   *  =================================================================== */

  /** This may not be entirely correct so should be used with care.
   */
  public void setSessionNum(int val);

  /** This may not be entirely correct so should be used with care.
   * Really just provides some measure of use.
   */
  public int getSessionNum();

  /** The current user
   *
   * @param val   String user
   */
  public void setUser(String val);

  public String getUser();

  /** Is this a guest user?
   *
   * @return boolean true for a guest
   */
  public boolean isGuest();

  /** The PresentationState object defines how the external information is
      presented, usually through some sort of XML/XSLT filtering
   */
  public void setPresentationState(PresentationState val);

  public PresentationState getPresentationState();
}

