/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.webcommon;

import edu.rpi.cct.uwcal.calsvci.CalSvcI;
import edu.rpi.cct.uwcal.calsvci.TimeDateComponents;
import edu.rpi.sss.util.jsp.UtilActionForm;
import edu.washington.cac.calfacade.shared.EventVO;
import edu.washington.cac.calfacade.shared.KeywordVO;
import edu.washington.cac.calfacade.shared.LocationVO;
import edu.washington.cac.calfacade.shared.MyCalendarVO;
import edu.washington.cac.calfacade.shared.SponsorVO;
import edu.washington.cac.calfacade.shared.UserAuth;

import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMapping;

/** Base for action form used by UWCal web applications
 *
 * @author  Mike Douglass     douglm@rpi.edu
 */
public class UWCalActionFormBase extends UtilActionForm {
  private UWCalSession sess;

  protected UserAuth userAuth;

  private MyCalendarVO today;

  /** true if this is a guest (unauthenticated) user
   */
  private boolean guest;

  /** true if we are showing the public face
   */
  private boolean publicView;

  private CalSvcI calsvci;

  private String[] yearVals;
  private static final int numYearVals = 10;
  private String curYear;

  /** Whether we show year data
   */
  private boolean showYearData;

  /** Starting values or date to go to
   */
  private TimeDateComponents eventStartDate;

  /** Ending date for events
   */
  private TimeDateComponents eventEndDate;

  private boolean hour24;

  private int minIncrement;

  /** Any one will do here. If it's null we create one
   */
  private TimeDateComponents forLabels;

  /** ===================================================================
   *           Fields for creating or editing objects
   *  =================================================================== */

  /** newKeyword is where we build a new keyword object
   */
  private KeywordVO newKeyword;

  /** editKeyword is where we hold a keyword object for editing
   */
  private KeywordVO editKeyword;

  /** newLocation is where we build a new location object
   */
  private LocationVO newLocation;

  /** editLocation is where we hold a location object for editing
   */
  private LocationVO editLocation;

  /** newSponsor is where we build a new Sponsor object
   */
  private SponsorVO newSponsor;

  /** editSponsor is where we hold a Sponsor object for editing
   */
  private SponsorVO editSponsor;

  /** newEvent is where we build a new Event object
   */
  private EventVO newEvent;

  /** editEvent is where we hold a Event object for editing
   */
  private EventVO editEvent;

  /** ===================================================================
   *                   Property methods
   *  =================================================================== */

  public void setCalSvcI(CalSvcI val) {
    calsvci = val;
  }

  public CalSvcI getCalSvcI() {
    return calsvci;
  }

  public UserAuth getUserAuth() {
    if (userAuth == null) {
      return null;
    }

    try {
      return userAuth.getUserAuthRO();
    } catch (Throwable t) {
      err.emit(t);
      return null;
    }
  }

  /* Don't call this getUserAuth or setUserAuth so it's hidden from the
     request stream
   */
  public void assignUserAuth(UserAuth val) {
    userAuth = val;
  }

  public UserAuth retrieveUserAuth() {
    return userAuth;
  }

  public void setToday(MyCalendarVO val) {
    today = val;
  }

  public MyCalendarVO getToday() {
    return today;
  }

  public void setGuest(boolean val) {
    guest = val;
  }

  public boolean getGuest() {
    return guest;
  }

  public void setPublicView(boolean val) {
    publicView = val;
  }

  public boolean getPublicView() {
    return publicView;
  }

  public void setHour24(boolean val) {
    hour24 = val;
  }

  public boolean getHour24() {
    return hour24;
  }


  public void setMinIncrement(int val) {
    minIncrement = val;
  }

  public int getMinIncrement() {
    return minIncrement;
  }

  public void assignShowYearData(boolean val) {
    showYearData = val;
  }

  public boolean getShowYearData() {
    return showYearData;
  }

  /** ===================================================================
   *                   Keywords
   *  =================================================================== */

/*  public KeywordVO[] getKeywords() {
    try {
      KeywordVO[] kk = calsvci.getKeywords();
      if (kk == null) {
        return new KeywordVO[0];
      }

      return kk;
    } catch (Throwable t) {
      if (debug) {
        t.printStackTrace();
      }
      err.emit(t);
      return new KeywordVO[0];
    }
  } */

  public KeywordVO getNewKeyword() {
    if (newKeyword == null) {
      newKeyword = new KeywordVO();
    }

    return newKeyword;
  }

  /** The only difference with newKeyword is this doesn't get reset
   */
  public void setEditKeyword(KeywordVO val) {
    editKeyword = val;
  }

  public KeywordVO getEditKeyword() {
    if (editKeyword == null) {
      editKeyword = new KeywordVO();
    }

    return editKeyword;
  }

  /** ===================================================================
   *                   Locations
   *  =================================================================== */

  public LocationVO[] getLocations() {
    try {
      LocationVO[] ll = calsvci.getLocations();
      if (ll == null) {
        return new LocationVO[0];
      }

      return ll;
    } catch (Throwable t) {
      if (debug) {
        t.printStackTrace();
      }
      err.emit(t);
      return new LocationVO[0];
    }
  }

  public LocationVO[] getPublicLocations() {
    try {
      LocationVO[] ll = calsvci.getPublicLocations();
      if (ll == null) {
        return new LocationVO[0];
      }

      return ll;
    } catch (Throwable t) {
      if (debug) {
        t.printStackTrace();
      }
      err.emit(t);
      return new LocationVO[0];
    }
  }

  public LocationVO getNewLocation() {
    if (newLocation == null) {
      newLocation = new LocationVO();
    }

    return tidyLocation(newLocation);
  }

  public void resetNewLocation() {
    newLocation = null;
  }

  /** The only difference with newLocation is this doesn't get reset
   */
  public void setEditLocation(LocationVO val) {
    editLocation = val;
  }

  public LocationVO getEditLocation() {
    if (editLocation == null) {
      editLocation = new LocationVO();
    }

    return tidyLocation(editLocation);
  }

  /** ===================================================================
   *                   Sponsors
   *  =================================================================== */

  /** Get the list of sponsors. Return a null list for exceptions or no
   * sponsors.
   *
   * @return SponsorVO[]    array of sponsors
   */
  public SponsorVO[] getSponsors() {
    try {
      SponsorVO[] ss = calsvci.getSponsors();
      if (ss == null) {
        return new SponsorVO[0];
      }

      return ss;
    } catch (Throwable t) {
      if (debug) {
        t.printStackTrace();
      }
      err.emit(t);
      return new SponsorVO[0];
    }
  }

  public SponsorVO getNewSponsor() {
    if (newSponsor == null) {
      newSponsor = new SponsorVO();
    }

    return newSponsor;
  }

  /** The only difference with newSponsor is this doesn't get reset
   */
  public void setEditSponsor(SponsorVO val) {
    editSponsor = val;
  }

  public SponsorVO getEditSponsor() {
    if (editSponsor == null) {
      editSponsor = new SponsorVO();
    }

    return editSponsor;
  }

  /** ===================================================================
   *                   Events
   *  =================================================================== */

  public EventVO getNewEvent() {
    if (newEvent == null) {
      newEvent = new EventVO();
    }

    return newEvent;
  }

  public void resetNewEvent() {
    newEvent = null;
  }

  /** The only difference from newEvent is this doesn't get reset
   */
  public void setEditEvent(EventVO val) {
    editEvent = val;

    getEventStartDate().setDateTime(val.getStartdate(), val.getStarttime());
    getEventEndDate().setDateTime(val.getEnddate(), val.getEndtime());
  }

  public EventVO getEditEvent() {
    if (editEvent == null) {
      editEvent = new EventVO();
    }

    return editEvent;
  }

  /** Return an initialised TimeDateComponents representing now
   *
   * @return TimeDateComponents  initialised object
   */
  public TimeDateComponents getNowTimeComponents() {
    try {
      TimeDateComponents tc = new TimeDateComponents(minIncrement,
                                                     hour24,
                                                     debug);

      tc.setNow();

      forLabels = tc;

      return tc;
    } catch (Throwable t) {
      if (debug) {
        t.printStackTrace();
      }
      err.emit(t);
      return null;
    }
  }

  /** ===================================================================
   *                   Start  and end Date and time
   *  =================================================================== */

  /** Methods related to selecting a particular date. These values may be
   * used when setting the current date or when setting the date of an event.
   * They will be distinguished by the action called.
   */

  /** Return an object representing an events start date.
   *
   * @return TimeDateComponents  object representing date and time
   */
  public TimeDateComponents getEventStartDate() {
    if (eventStartDate == null) {
      eventStartDate = getNowTimeComponents();
    }

    return eventStartDate;
  }

  /** Return an object representing an events end date.
   *
   * @return TimeDateComponents  object representing date and time
   */
  public TimeDateComponents getEventEndDate() {
    if (eventEndDate == null) {
      eventEndDate = getNowTimeComponents();
    }

    return eventEndDate;
  }

  public void resetEventStartDate() {
    eventStartDate = null;
  }

  public void resetEventEndDate() {
    eventEndDate = null;
  }

  /** ===================================================================
   *                Date and time labels for select boxes
   *  =================================================================== */

  public String[] getYearVals() {
    if (yearVals == null) {
      yearVals = new String[numYearVals];
      int year = Calendar.getInstance().get(Calendar.YEAR);
      curYear = "" + year;

      for (int i = 0; i < numYearVals; i++) {
        yearVals[i] = "" + (year + i);
      }
    }

    return yearVals;
  }

  public TimeDateComponents getForLabels() {
    if (forLabels == null) {
      getNowTimeComponents();
    }

    return forLabels;
  }

  public void setSession(UWCalSession val) {
    sess = val;
  }

  public UWCalSession getSession() {
    return  sess;
  }

  /** Make sure string fields are null - no zero length
   */
  public LocationVO tidyLocation(LocationVO loc) {
    loc.setAddress(checkNull(loc.getAddress()));
    loc.setSubaddress(checkNull(loc.getSubaddress()));
    loc.setLink(checkNull(loc.getLink()));

    return loc;
  }

  /**
   * Reset properties to their default values.
   *
   * @param mapping The mapping used to select this instance
   * @param request The servlet request we are processing
   */
  public void reset(ActionMapping mapping, HttpServletRequest request) {
    newKeyword = null;
    newSponsor = null;
  }

}

