/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.common;

import edu.washington.cac.calfacade.shared.Calintf;
import edu.washington.cac.calfacade.shared.MyCalendarVO;

/** This class represents a year of events. The firstDay and lastDay are set
 * to be the latest and earliest including the curDay.
 *
 * @author  Mike Douglass douglm@rpi.edu
 */
public class YearView extends TimeView {
  /** Constructor:
   *
   * @param  curDay    MyCalendarVO representing current day.
   * @param  cal       Calintf calendar interface
   * @param  showData  boolean true if this TimeView can be used to
   *                   display events or if it is used for structure only.
   *                   For example we may use the year for navigation only
   *                   to reduce the amount of data retrieved.
   * @param  debug     true for some debugging output
   */
  public YearView(MyCalendarVO curDay,
                  Calintf cal,
                  boolean showData,
                  boolean debug) {
    super(curDay, "Year", cal,
          curDay.getFirstDayOfThisYear(),
          curDay.getLastDayOfThisYear(),
          curDay.getPrevYear().getDateDigits(),
          curDay.getNextYear().getDateDigits(),
          showData,
          debug);
  }
}

