/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.common;

import java.io.Serializable;

/** This interface defines some values for the UWCal web interface.
 *
 * @author Mike Douglass   douglm@rpi.edu
 */
public interface UWCalDefs extends Serializable {
  /** These names are internal
   */
  public static final String[] viewTypeNames =
    {"todayView", "dayView", "weekView", "monthView", "yearView"};

  public static final int todayView = 0;
  public static final int dayView = 1;
  public static final int weekView = 2;
  public static final int monthView = 3;
  public static final int yearView = 4;

  public static final int defaultView = weekView;
}

