/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.common;

import edu.washington.cac.calfacade.shared.EventVO;
import edu.washington.cac.calfacade.shared.MyCalendarVO;

import java.io.Serializable;
import org.apache.log4j.Logger;

/** This class allows a TimeView class to provide information about each day
 * represented by that view. This can be used to build grids or tables.
 *
 * <p>This information is always returned as a hierarchical set of these
 * entries with the top being years, containing months, weeks and days.
 *
 * @author  Mike Douglass douglm@rpi.edu
 */
public class TimeViewDailyInfo implements Serializable {
  /** The view that created this.
   */
  private TimeView view;

  /** Date as MyCalendarVO object
   */
  private MyCalendarVO cal;

  /** true if this is just a filler - we insert filler into weeks so that they
   always havea  weekful of entries even as we cross month boundaries
   */
  private boolean filler;

  /** true if this is a day entry
   */
  private boolean dayEntry;

  /** More than one entry
   */
  private boolean multiDay;

  /** Date as YYYYMMDD
   */
  private String date;

  /** Short printable date
   */
  private String dateShort;

  /** Long printable date
   */
  private String dateLong;

  /** True if this is in the current month
   */
  private boolean currentMonth;

  /** Is first of period
   */
  private boolean firstDay;

  /** Is last of period
   */
  private boolean lastDay;

  /** Is first of week
   */
  private boolean firstDayOfWeek;

  /** Is last of week
   */
  private boolean lastDayOfWeek;

  /** Is first of month
   */
  private boolean firstDayOfMonth;

  /** Is last of month
   */
  private boolean lastDayOfMonth;

  /** Day of week
   */
  private int dayOfWeek;

  /** Day of month as numeric string
   */
  private int dayOfMonth;

  /** Week of year as numeric string
   */
  private String weekOfYear;

  /** Name of day of month
   */
  private String dayName;

  /** Month as numeric string
   */
  private String month;

  /** Name of month
   */
  private String monthName;

  /** Year as numeric string
   */
  private String year;

  /** The entries this contains, if this is years next is months, then weeks
   * then days.
   */
  private TimeViewDailyInfo[] entries;

  /** The events - possibly null
   */
  private EventVO[] events;

  /** The wrapped events - possibly null
   */
  private EventFormatter[] eventFormatters;

  /** The view that created this.
   */
  public void setView(TimeView val) {
    view = val;
  }

  /** The view that created this.
   */
  public TimeView getView() {
    return view;
  }

  public void setCal(MyCalendarVO val) {
    cal = val;
  }

  public MyCalendarVO getCal() {
    return cal;
  }

  public void setFiller(boolean val) {
    filler = val;
  }

  public boolean getFiller() {
    return filler;
  }

  public void setDayEntry(boolean val) {
    dayEntry = val;
  }

  public boolean getDayEntry() {
    return dayEntry;
  }


  public void setMultiDay(boolean val) {
    multiDay = val;
  }

  public boolean isMultiDay() {
    return multiDay;
  }

  public void setDate(String val) {
    date = val;
  }

  public String getDate() {
    return date;
  }

  public void setDateShort(String val) {
    dateShort = val;
  }

  public String getDateShort() {
    return dateShort;
  }

  public void setDateLong(String val) {
    dateLong = val;
  }

  public String getDateLong() {
    return dateLong;
  }

  public void setCurrentMonth(boolean val) {
    currentMonth = val;
  }

  public boolean isCurrentMonth() {
    return currentMonth;
  }

  public void setFirstDay(boolean val) {
    firstDay = val;
  }

  public boolean isFirstDay() {
    return firstDay;
  }

  public void setLastDay(boolean val) {
    lastDay = val;
  }

  public boolean isLastDay() {
    return lastDay;
  }

  public void setFirstDayOfWeek(boolean val) {
    firstDayOfWeek = val;
  }

  public boolean isFirstDayOfWeek() {
    return firstDayOfWeek;
  }

  public void setLastDayOfWeek(boolean val) {
    lastDayOfWeek = val;
  }

  public boolean isLastDayOfWeek() {
    return lastDayOfWeek;
  }

  public void setFirstDayOfMonth(boolean val) {
    firstDayOfMonth = val;
  }

  public boolean isFirstDayOfMonth() {
    return firstDayOfMonth;
  }

  public void setLastDayOfMonth(boolean val) {
    lastDayOfMonth = val;
  }

  public boolean isLastDayOfMonth() {
    return lastDayOfMonth;
  }

  public void setDayOfWeek(int val) {
    dayOfWeek = val;
  }

  public int getDayOfWeek() {
    return dayOfWeek;
  }

  public void setDayOfMonth(int val) {
    dayOfMonth = val;
  }

  public int getDayOfMonth() {
    return dayOfMonth;
  }

  public void setWeekOfYear(String val) {
    weekOfYear = val;
  }

  public String getWeekOfYear() {
    return weekOfYear;
  }

  public void setDayName(String val) {
    dayName = val;
  }

  public String getDayName() {
    return dayName;
  }

  public void setMonth(String val) {
    month = val;
  }

  public String getMonth() {
    return month;
  }

  public void setMonthName(String val) {
    monthName = val;
  }

  public String getMonthName() {
    return monthName;
  }

  public String getShortMonthName() {
    if (monthName == null) {
      return "?";
    }
    return monthName.substring(0, 3);
  }

  public void setYear(String val) {
    year = val;
  }

  public String getYear() {
    return year;
  }

  public void setEntries(TimeViewDailyInfo[] val) {
    entries = val;
  }

  public TimeViewDailyInfo[] getEntries() {
    return entries;
  }

  public void setEvents(EventVO[] val) {
    events = val;
    eventFormatters = null;
  }

  public EventVO[] getEvents() throws Throwable {
    if (events == null) {
      events = getDaysEvents(cal);
      eventFormatters = null;
    }

    return events;
  }

  public EventFormatter[] getEventFormatters() throws Throwable {
    try {
      getEvents();

      if (eventFormatters == null) {
        if (events == null) {
          return null;
        }

        eventFormatters = new EventFormatter[events.length];

        for (int i = 0; i < events.length; i++) {
          eventFormatters[i] = new EventFormatter(events[i], view);
        }
      }
    } catch (Throwable t) {
      t.printStackTrace();
      throw t;
    }

    return eventFormatters;
  }

  /** Return the events for the day as an array of value objects
   * !!!!!!! Needs to throw an exception for an error.
   *
   * @param   date    MyCalendarVO object defining day
   * @return  EventVO[]  one days events,  never null, length 0 for no events.
   * @exception Exception if this is not a day object
   */
  private EventVO[] getDaysEvents(MyCalendarVO date) throws Throwable {
    if (!getDayEntry()) {
      Logger.getLogger(this.getClass()).error("*******Not a day entry*****");
      throw new Exception("Not a day entry");
    }

    return view.getDaysEvents(date);
  }
}

