/* **********************************************************************
    Copyright 2003 Rensselaer Polytechnic Institute.

    All worldwide rights reserved. A license to use, copy, modify and
    distribute this software for noncommercial research purposes only is
    hereby granted, provided that this copyright notice and accompanying
    disclaimer is not modified or removed from the software.

    DISCLAIMER: The software is distributed" AS IS" without any express or
    implied warranty, including but not limited to, any implied warranties
    of merchantability or fitness for a particular purpose or any warrant)'
    of non-infringement of any current or pending patent rights. The authors
    of the software make no representations about the suitability of this
    software for any particular purpose. The entire risk as to the quality
    and performance of the software is with the user. Should the software
    prove defective, the user assumes the cost of all necessary servicing,
    repair or correction. In particular, neither Rensselaer Polytechnic
    Institute, nor the authors of the software are liable for any indirect,
    special, consequential, or incidental damages related to the software,
    to the maximum extent the law permits.
*/

package edu.rpi.cct.uwcal.common;

/** This class is used by the clients to determine which of two incoming
 * request parameters will set the final value. It is typically used when we
 * have preferred and all select boxes and we get an id from each.
 *
 * @author  Mike Douglass douglm@rpi.edu
 */
public class IntSelectId {
  public static final int NoneHasPrecedence = 0;
  public static final int AHasPrecedence = 1;
  public static final int BHasPrecedence = 2;

  private int precedence;

  private int originalValue;
  private int newValue;

  private boolean changed;

  /** Create an object with the given original value in which neither A nor B
   * have preference.
   */
  public IntSelectId(int originalValue) {
    this.originalValue = originalValue;
    this.newValue = originalValue;
  }

  /** Create an object with the given original value indicating which of A
   * or B have preference.
   */
  public IntSelectId(int originalValue, int preferred) {
    this.originalValue = originalValue;
    this.newValue = originalValue;
    precedence = preferred;
  }

  public void setA(int val) {
    if (val == originalValue) {
      return;
    }

    if (!changed ||
        (precedence == AHasPrecedence) ||
        (precedence == NoneHasPrecedence)) {
      newValue = val;
      changed = true;
    }
  }

  public void setB(int val) {
    if (val == originalValue) {
      return;
    }

    if (!changed ||
        (precedence == BHasPrecedence) ||
        (precedence == NoneHasPrecedence)) {
      newValue = val;
      changed = true;
    }
  }

  public boolean getChanged() {
    return changed;
  }

  public int getOriginalVal() {
    return originalValue;
  }

  public int getVal() {
    return newValue;
  }
}

