#! /bin/sh

#   Copyright (c) 2001-2003 The Apache Software Foundation.  All rights
#   reserved.

# load system-wide ant configuration
if [ -f "/etc/ant.conf" ] ; then 
  . /etc/ant.conf
fi

# provide default values for people who don't use RPMs
if [ -z "$rpm_mode" ] ; then
  rpm_mode=false;
fi
if [ -z "$usejikes" ] ; then
  usejikes=false;
fi

# load user ant configuration
if [ -f "$HOME/.antrc" ] ; then 
  . "$HOME/.antrc"
fi

# OS specific support.  $var _must_ be set to either true or false.
cygwin=false;
darwin=false;
case "`uname`" in
  CYGWIN*) cygwin=true ;;
  Darwin*) darwin=true
           if [ -z "$JAVA_HOME" ] ; then
             JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Home   
           fi
           ;;
esac

if [ -z "$ANT_HOME" ] ; then
  # try to find ANT
  if [ -d /opt/ant ] ; then 
    ANT_HOME=/opt/ant
  fi

  if [ -d "${HOME}/opt/ant" ] ; then 
    ANT_HOME="${HOME}/opt/ant"
  fi

  ## resolve links - $0 may be a link to ant's home
  PRG="$0"
  progname=`basename "$0"`
  saveddir=`pwd`

  # need this for relative symlinks
  dirname_prg=`dirname "$PRG"`
  cd "$dirname_prg"
  
  while [ -h "$PRG" ] ; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '.*-> \(.*\)$'`
    if expr "$link" : '/.*' > /dev/null; then
	PRG="$link"
    else
	PRG=`dirname "$PRG"`"/$link"
    fi
  done
  
  ANT_HOME=`dirname "$PRG"`/apache-ant-1.5.4

  cd "$saveddir"

  # make it fully qualified
  ANT_HOME=`cd "$ANT_HOME" && pwd`
fi

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin ; then
  [ -n "$ANT_HOME" ] &&
    ANT_HOME=`cygpath --unix "$ANT_HOME"`
  [ -n "$JAVA_HOME" ] &&
    JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
  [ -n "$CLASSPATH" ] &&
    CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

# set ANT_LIB location
ANT_LIB="${ANT_HOME}/lib"

if [ -z "$JAVACMD" ] ; then 
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then 
      # IBM's JDK on AIX uses strange locations for the executables
      JAVACMD="$JAVA_HOME/jre/sh/java"
    else
      JAVACMD="$JAVA_HOME/bin/java"
    fi
  else
    JAVACMD=`which java 2> /dev/null `
    if [ -z "$JAVACMD" ] ; then 
        JAVACMD=java
    fi
  fi
fi
 
if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit 1
fi

if [ -n "$CLASSPATH" ] ; then
  LOCALCLASSPATH="$CLASSPATH"
fi

# in rpm_mode get ant/optional/xml parser&api from JAVALIBDIR 
if $rpm_mode; then
  JAVALIBDIR=/usr/share/java
  for i in ant ant-optional jaxp_parser xml_apis 
  do
    if [ -z "$LOCALCLASSPATH" ] ; then
      LOCALCLASSPATH="$JAVALIBDIR/$i.jar"
    else
      LOCALCLASSPATH="$JAVALIBDIR/$i.jar":"$LOCALCLASSPATH"
    fi
  done

  # in rpm mode ant/lib is in /usr/share/java/ant
  ANT_LIB="${JAVALIBDIR}/ant"
fi

# add in the dependency .jar files in non-RPM mode (the default)
for i in "${ANT_LIB}"/*.jar
do
  # if the directory is empty, then it will return the input string
  # this is stupid, so case for it
  if [ -f "$i" ] ; then
    if [ -z "$LOCALCLASSPATH" ] ; then
      LOCALCLASSPATH="$i"
    else
      LOCALCLASSPATH="$i":"$LOCALCLASSPATH"
    fi
  fi
done

if [ -n "$JAVA_HOME" ] ; then
  if [ -f "$JAVA_HOME/lib/tools.jar" ] ; then
    LOCALCLASSPATH="$LOCALCLASSPATH:$JAVA_HOME/lib/tools.jar"
  fi

  if [ -f "$JAVA_HOME/lib/classes.zip" ] ; then
    LOCALCLASSPATH="$LOCALCLASSPATH:$JAVA_HOME/lib/classes.zip"
  fi

  # OSX hack to make Ant work with jikes
  if $darwin ; then
    OSXHACK="${JAVA_HOME}/../Classes"
    if [ -d "${OSXHACK}" ] ; then
      for i in "${OSXHACK}"/*.jar
      do
        JIKESPATH="$JIKESPATH:$i"
      done
    fi
  fi
else
  echo "Warning: JAVA_HOME environment variable is not set (or not exported)."
  echo "  If build fails because sun.* classes could not be found"
  echo "  you will need to set the JAVA_HOME environment variable"
  echo "  to the installation directory of java."
fi

# Allow Jikes support (off by default)
if $usejikes; then
  ANT_OPTS="$ANT_OPTS -Dbuild.compiler=jikes"
fi

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
  ANT_HOME=`cygpath --windows "$ANT_HOME"`
  JAVA_HOME=`cygpath --windows "$JAVA_HOME"`
  CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
  LOCALCLASSPATH=`cygpath --path --windows "$LOCALCLASSPATH"`
  CYGHOME=`cygpath --windows "$HOME"`
fi

if [ -n "$CYGHOME" ]; then
  if [ -n "$JIKESPATH" ]; then
    JIKESPATH=`cygpath --path --windows "$JIKESPATH"`
    "$JAVACMD" $ANT_OPTS -classpath "$LOCALCLASSPATH" -Dant.home="${ANT_HOME}" -Djikes.class.path="$JIKESPATH" -Dcygwin.user.home="$CYGHOME" org.apache.tools.ant.Main $ANT_ARGS "$@"
  else
    "$JAVACMD" $ANT_OPTS -classpath "$LOCALCLASSPATH" -Dant.home="${ANT_HOME}" -Dcygwin.user.home="$CYGHOME" org.apache.tools.ant.Main $ANT_ARGS "$@"
  fi
else
  if [ -n "$JIKESPATH" ]; then
    "$JAVACMD" $ANT_OPTS -classpath "$LOCALCLASSPATH" -Dant.home="${ANT_HOME}" -Djikes.class.path="$JIKESPATH" org.apache.tools.ant.Main $ANT_ARGS "$@"
  else
    "$JAVACMD" $ANT_OPTS -classpath "$LOCALCLASSPATH" -Dant.home="${ANT_HOME}" org.apache.tools.ant.Main $ANT_ARGS "$@"
  fi
fi

