/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SocketTransport;
import com.sun.tools.jdi.TransportService;
import com.sun.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

class SocketAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_PORT = "port";
    static final String ARG_HOST = "hostname";
    TransportService transport;

    public Transport transport() {
        return this.transport;
    }

    SocketAttachingConnector(VirtualMachineManagerService virtualMachineManagerService) {
        super(virtualMachineManagerService);
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        this.addStringArgument(ARG_HOST, this.getString("socket_attaching.host.label"), this.getString("socket_attaching.host"), string, false);
        this.addIntegerArgument(ARG_PORT, this.getString("socket_attaching.port.label"), this.getString("socket_attaching.port"), "", true, 0, Integer.MAX_VALUE);
        this.transport = new SocketTransport();
    }

    public String description() {
        return this.getString("socket_attaching.description");
    }

    public String name() {
        return "com.sun.jdi.SocketAttach";
    }

    public VirtualMachine attach(Map map) throws IOException, IllegalConnectorArgumentsException {
        String string = this.argument(ARG_PORT, map).value();
        String string2 = this.argument(ARG_HOST, map).value();
        if (string2.length() == 0) {
            string2 = "localhost";
        }
        string2 = string2 + ":";
        ConnectionService connectionService = this.transport.attach(string2 + string);
        return this.manager().createVirtualMachine(connectionService);
    }
}

