/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8;

import com.sun.tools.javac.v8.code.ClassReader;
import com.sun.tools.javac.v8.code.ClassWriter;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Symtab;
import com.sun.tools.javac.v8.comp.Attr;
import com.sun.tools.javac.v8.comp.Check;
import com.sun.tools.javac.v8.comp.Enter;
import com.sun.tools.javac.v8.comp.Env;
import com.sun.tools.javac.v8.comp.Flow;
import com.sun.tools.javac.v8.comp.Gen;
import com.sun.tools.javac.v8.comp.Todo;
import com.sun.tools.javac.v8.comp.TransInner;
import com.sun.tools.javac.v8.comp.TransTypes;
import com.sun.tools.javac.v8.parser.Parser;
import com.sun.tools.javac.v8.parser.Scanner;
import com.sun.tools.javac.v8.tree.Pretty;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeMaker;
import com.sun.tools.javac.v8.util.Abort;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Options;
import com.sun.tools.javac.v8.util.Set;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class JavaCompiler
implements ClassReader.SourceCompleter {
    private static final Context.Key compilerKey;
    private Log log;
    private TreeMaker make;
    private ClassReader reader;
    ClassWriter writer;
    private Enter enter;
    private Gen gen;
    private Name.Table names;
    private Context context;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean attrParseOnly;
    public boolean classOutput;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public boolean genCrt;
    public String encoding;
    private Todo todo;
    Set inputFiles = Set.make();
    private boolean hasBeenUsed = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int errorCount() {
        return this.log.nerrors;
    }

    static {
        $assertionsDisabled = !JavaCompiler.class.desiredAssertionStatus();
        compilerKey = new Context.Key();
    }

    public void close() {
        this.log.flush();
        this.reader.close();
        this.names.dispose();
    }

    protected boolean keepComments() {
        return this.sourceOutput;
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.context = context;
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.classOutput = options.get("-retrofit") == null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.get("-deprecation") != null;
        this.warnunchecked = options.get("-warnunchecked") != null;
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.genCrt = options.get("-Xjcov") != null;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    private void noteDeprecated(String string) {
        if (string.equals("*")) {
            this.log.note("deprecated.plural");
        } else {
            this.log.note("deprecated.filename", string);
        }
        this.log.note("deprecated.recompile");
    }

    void noteUnchecked(String string) {
        if (string.equals("*")) {
            this.log.note("unchecked.plural");
        } else {
            this.log.note("unchecked.filename", string);
        }
        this.log.note("unchecked.recompile");
    }

    void printCount(String string, int n) {
        if (n != 0) {
            Log.printLines(this.log.errWriter, Log.getLocalizedString("count." + string, Integer.toString(n)));
            this.log.errWriter.flush();
        }
    }

    public static JavaCompiler make(Context context) {
        try {
            Symtab symtab = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            Log log = Log.instance(context);
            log.error(0, completionFailure.getMessage());
            return null;
        }
        return new JavaCompiler(context);
    }

    void genCode(Env env, Tree.ClassDef classDef) throws IOException {
        try {
            if (this.gen.genClass(env, classDef)) {
                this.writer.writeClass(classDef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow poolOverflow) {
            this.log.error(classDef.pos, "limit.pool");
        }
        catch (ClassWriter.StringOverflow stringOverflow) {
            this.log.error(classDef.pos, "limit.string.overflow", stringOverflow.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(0, completionFailure.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env env, Tree.ClassDef classDef) throws IOException {
        File file = this.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file.toString());
        } else {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            try {
                new Pretty(printWriter, true).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
            }
            finally {
                printWriter.close();
            }
        }
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    public List compile(List list) throws Throwable {
        int n;
        Object object;
        if (!$assertionsDisabled && this.hasBeenUsed) {
            throw new AssertionError((Object)"attempt to reuse JavaCompiler");
        }
        this.hasBeenUsed = true;
        long l = System.currentTimeMillis();
        ListBuffer listBuffer = new ListBuffer();
        try {
            Object object2;
            Object object3;
            Object object4;
            object = new ListBuffer();
            List list2 = list;
            while (list2.nonEmpty()) {
                ((ListBuffer)object).append(this.parse((String)list2.head));
                list2 = list2.tail;
            }
            list2 = ((ListBuffer)object).toList();
            if (this.errorCount() == 0) {
                this.enter.main(list2);
            }
            List list3 = null;
            if (this.sourceOutput) {
                object4 = new ListBuffer();
                object3 = list2;
                while (((List)object3).nonEmpty()) {
                    object2 = ((Tree.TopLevel)((List)object3).head).defs;
                    while (((List)object2).nonEmpty()) {
                        if (((List)object2).head instanceof Tree.ClassDef) {
                            ((ListBuffer)object4).append((Tree.ClassDef)((List)object2).head);
                        }
                        object2 = ((List)object2).tail;
                    }
                    object3 = ((List)object3).tail;
                }
                list3 = ((ListBuffer)object4).toList();
            }
            object4 = Attr.instance(this.context);
            this.gen = Gen.instance(this.context);
            object3 = Flow.instance(this.context);
            object2 = TransTypes.instance(this.context);
            TransInner transInner = TransInner.instance(this.context);
            while (this.todo.nonEmpty()) {
                Env env = (Env)this.todo.next();
                Tree tree = env.tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", env.enclClass.sym.toJava());
                }
                Name name = this.log.useSource(env.enclClass.sym.sourcefile);
                ((Attr)object4).attribClass(env.tree.pos, env.enclClass.sym);
                if (this.attrParseOnly) continue;
                this.make.at(1025);
                TreeMaker treeMaker = new TreeMaker(env.toplevel);
                if (this.errorCount() == 0) {
                    ((Flow)object3).analyzeTree(env.tree, treeMaker);
                }
                if (this.errorCount() == 0) {
                    env.tree = ((TransTypes)object2).translateTopLevelClass(env.tree, treeMaker);
                }
                if (this.errorCount() == 0) {
                    Tree.ClassDef classDef = null;
                    try {
                        if (this.sourceOutput) {
                            classDef = (Tree.ClassDef)env.tree;
                            if (tree instanceof Tree.ClassDef && list3.contains((Tree.ClassDef)tree)) {
                                this.printSource(env, classDef);
                            }
                        } else {
                            List list4 = transInner.translateTopLevelClass(env, env.tree, treeMaker);
                            if (this.errorCount() == 0) {
                                List list5 = list4;
                                while (this.errorCount() == 0 && list5.nonEmpty()) {
                                    classDef = (Tree.ClassDef)list5.head;
                                    if (this.printFlat) {
                                        this.printSource(env, classDef);
                                    } else if (this.classOutput) {
                                        this.genCode(env, classDef);
                                    }
                                    listBuffer.append(classDef.sym);
                                    list5 = list5.tail;
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        this.log.error(classDef.pos, "class.cant.write", classDef.sym.toJava(), iOException.getMessage());
                    }
                }
                this.log.useSource(name);
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        object = Check.instance(this.context);
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (((Check)object).deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(((Check)object).deprecatedSource.toString());
        }
        if (((Check)object).uncheckedSource != null && !this.warnunchecked) {
            this.noteUnchecked(((Check)object).uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return listBuffer.toList();
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.put(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", string);
            return null;
        }
    }

    private void printVerbose(String string, String string2) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, string2));
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(this.names.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = new Scanner(this.context, inputStream, this.encoding);
                inputStream.close();
                Parser parser = new Parser(this.context, scanner, this.keepComments(), this.genCrt);
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, "error.reading.file", string, iOException.toString());
            }
        }
        this.log.useSource(name);
        topLevel.sourcefile = this.names.fromString(string);
        return topLevel;
    }

    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.complete(List.make(topLevel), classSymbol);
        if (this.enter.getEnv(classSymbol) == null) {
            throw new ClassReader.BadClassFile(classSymbol, string, Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname.toJava()));
        }
    }
}

