/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class CoyoteResponseFacade
extends ResponseFacade
implements HttpServletResponse {
    protected CoyoteResponse response = null;

    public CoyoteResponseFacade(CoyoteResponse response) {
        super(response);
        this.response = response;
    }

    public void clear() {
        this.response = null;
    }

    public void finish() {
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        return this.response.isSuspended();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream sos = this.response.getOutputStream();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return sos;
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = this.response.getWriter();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return writer;
    }

    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type));
        } else {
            this.response.setContentType(type);
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CoyoteResponseFacade.this.response.setAppCommitted(true);
                        CoyoteResponseFacade.this.response.flushBuffer();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) return;
                throw (IOException)ex;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        return this.response.isAppCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    public void setLocale(Locale loc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.response.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.response.encodeRedirectURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc, sm);
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction {
        private String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        public Object run() {
            CoyoteResponseFacade.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

