/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletInputStream;
import org.apache.coyote.tomcat5.InputBuffer;

public class CoyoteInputStream
extends ServletInputStream {
    protected InputBuffer ib;

    protected CoyoteInputStream(InputBuffer ib) {
        this.ib = ib;
    }

    public int read() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(CoyoteInputStream.this.ib.readByte());
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.readByte();
    }

    public int available() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(CoyoteInputStream.this.ib.available());
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.available();
    }

    public int read(final byte[] b) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(CoyoteInputStream.this.ib.read(b, 0, b.length));
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, 0, b.length);
    }

    public int read(final byte[] b, final int off, final int len) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                Integer result = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        Integer integer = new Integer(CoyoteInputStream.this.ib.read(b, off, len));
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.ib.read(b, off, len);
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        return super.readLine(b, off, len);
    }

    public void close() throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.ib.close();
        }
    }
}

