/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyotePrincipal;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;

final class CoyoteAdapter
implements Adapter {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$coyote$tomcat5$CoyoteAdapter == null ? (class$org$apache$coyote$tomcat5$CoyoteAdapter = CoyoteAdapter.class$("org.apache.coyote.tomcat5.CoyoteAdapter")) : class$org$apache$coyote$tomcat5$CoyoteAdapter));
    public static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    private int debug = 0;
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    protected StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    static /* synthetic */ Class class$org$apache$coyote$tomcat5$CoyoteAdapter;

    public CoyoteAdapter(CoyoteConnector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (request == null) {
            request = (CoyoteRequest)this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = (CoyoteResponse)this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse(response);
            response.setRequest(request);
            req.setNote(1, (Object)request);
            res.setNote(1, (Object)response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (this.connector.isXpoweredBy()) {
            response.addHeader("X-Powered-By", "Servlet/2.4");
        }
        try {
            if (!this.postParseRequest(req, request, res, response)) {
                return;
            }
            if (!request.getMappingData().redirectPath.isNull()) {
                response.sendRedirect(request.getMappingData().redirectPath.toString());
            } else {
                this.connector.getContainer().invoke(request, response);
            }
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            log.error((Object)this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            request.recycle();
            response.recycle();
        }
    }

    protected boolean postParseRequest(Request req, CoyoteRequest request, Response res, CoyoteResponse response) throws Exception {
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            req.setServerPort(proxyPort);
        }
        if (proxyName != null) {
            req.serverName().setString(proxyName);
        }
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        try {
            req.getURLDecoder().convert(decodedURI, false);
        }
        catch (IOException ioe) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            throw ioe;
        }
        if (!CoyoteAdapter.normalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            return false;
        }
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        this.convertURI(decodedURI, request);
        this.parseSessionId(req, request);
        CharChunk uriCC = decodedURI.getCharChunk();
        int semicolon = uriCC.indexOf(';');
        if (semicolon > 0) {
            decodedURI.setChars(uriCC.getBuffer(), uriCC.getStart(), semicolon);
        }
        this.connector.getMapper().map(req.serverName(), decodedURI, request.getMappingData());
        request.setContext((Context)request.getMappingData().context);
        request.setWrapper((Wrapper)request.getMappingData().wrapper);
        this.parseCookies(req, request);
        return true;
    }

    protected void parseSessionId(Request req, CoyoteRequest request) {
        CharChunk uriCC = req.decodedURI().getCharChunk();
        int semicolon = uriCC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            int start = uriCC.getStart();
            int end = uriCC.getEnd();
            int sessionIdStart = start + semicolon + match.length();
            int semicolon2 = uriCC.indexOf(';', sessionIdStart);
            if (semicolon2 >= 0) {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, semicolon2 - semicolon - match.length()));
            } else {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, end - sessionIdStart));
            }
            request.setRequestedSessionURL(true);
            ByteChunk uriBC = req.requestURI().getByteChunk();
            start = uriBC.getStart();
            end = uriBC.getEnd();
            semicolon = uriBC.indexOf(match, 0, match.length(), 0);
            if (semicolon > 0) {
                sessionIdStart = start + semicolon;
                semicolon2 = uriCC.indexOf(';', start + semicolon + match.length());
                uriBC.setEnd(start + semicolon);
                byte[] buf = uriBC.getBuffer();
                if (semicolon2 >= 0) {
                    for (int i = 0; i < end - start - semicolon2; ++i) {
                        buf[start + semicolon + i] = buf[start + i + semicolon2];
                    }
                    uriBC.setBytes(buf, start, semicolon + (end - start - semicolon2));
                }
            }
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
    }

    protected void parseCookies(Request req, CoyoteRequest request) {
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        Cookie[] cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (scookie.getName().equals("JSESSIONID") && !request.isRequestedSessionIdFromCookie()) {
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Requested cookie session id is " + ((HttpServletRequest)request.getRequest()).getRequestedSessionId()));
                }
            }
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
                cookie.setPath(scookie.getPath().toString());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain().toString());
                }
                cookies[idx++] = cookie;
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Bad Cookie Name: " + scookie.getName() + " /Value: " + scookie.getValue()), (Throwable)ex);
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(cookies, 0, ncookies, 0, idx);
            cookies = ncookies;
        }
        request.setCookies(cookies);
    }

    protected void convertURI(MessageBytes uri, CoyoteRequest request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                } else {
                    conv.recycle();
                }
            }
            catch (IOException e) {
                log.error((Object)"Invalid URI encoding; using HTTP default");
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.error((Object)"Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                b[pos] = 47;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    protected void log(String message) {
        log.info((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.error((Object)message, throwable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

