/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tomcat.util.compat.JdkCompat;

public class ErrorReportValve
extends ValveBase {
    private int debug = 0;
    private static final String info = "org.apache.catalina.valves.ErrorReportValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        ServletRequest sreq = (ServletRequest)request;
        Throwable throwable = (Throwable)sreq.getAttribute("javax.servlet.error.exception");
        ServletResponse sresp = (ServletResponse)response;
        if (sresp.isCommitted()) {
            return;
        }
        if (throwable != null) {
            response.setError();
            try {
                sresp.reset();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            ServletResponse sresponse = (ServletResponse)response;
            if (sresponse instanceof HttpServletResponse) {
                ((HttpServletResponse)sresponse).sendError(500);
            }
        }
        response.setSuspended(false);
        try {
            this.report(request, response, throwable);
        }
        catch (Throwable tt) {
            tt.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ErrorReportValve[");
        sb.append(this.container.getName());
        sb.append("]");
        return sb.toString();
    }

    protected void report(Request request, Response response, Throwable throwable) throws IOException {
        block22: {
            String message;
            if (!(response instanceof HttpResponse)) {
                return;
            }
            HttpResponse hresponse = (HttpResponse)response;
            if (!(response instanceof HttpServletResponse)) {
                return;
            }
            HttpServletResponse hres = (HttpServletResponse)response;
            int statusCode = hresponse.getStatus();
            if (statusCode < 400) {
                return;
            }
            Throwable rootCause = null;
            if (throwable != null && throwable instanceof ServletException) {
                rootCause = ((ServletException)throwable).getRootCause();
            }
            if ((message = RequestUtil.filter(hresponse.getMessage())) == null) {
                message = "";
            }
            String report = null;
            try {
                report = sm.getString("http." + statusCode, message);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (report == null) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<html><head><title>");
            sb.append(ServerInfo.getServerInfo()).append(" - ");
            sb.append(sm.getString("errorReportValve.errorReport"));
            sb.append("</title>");
            sb.append("<style><!--");
            sb.append("H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}HR {color : #525D76;}");
            sb.append("--></style> ");
            sb.append("</head><body>");
            sb.append("<h1>");
            sb.append(sm.getString("errorReportValve.statusHeader", "" + statusCode, message)).append("</h1>");
            sb.append("<HR size=\"1\" noshade>");
            sb.append("<p><b>type</b> ");
            if (throwable != null) {
                sb.append(sm.getString("errorReportValve.exceptionReport"));
            } else {
                sb.append(sm.getString("errorReportValve.statusReport"));
            }
            sb.append("</p>");
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.message"));
            sb.append("</b> <u>");
            sb.append(message).append("</u></p>");
            sb.append("<p><b>");
            sb.append(sm.getString("errorReportValve.description"));
            sb.append("</b> <u>");
            sb.append(report);
            sb.append("</u></p>");
            if (throwable != null) {
                String stackTrace = JdkCompat.getJdkCompat().getPartialServletStackTrace(throwable);
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.exception"));
                sb.append("</b> <pre>");
                sb.append(stackTrace);
                sb.append("</pre></p>");
                while (rootCause != null) {
                    stackTrace = JdkCompat.getJdkCompat().getPartialServletStackTrace(rootCause);
                    sb.append("<p><b>");
                    sb.append(sm.getString("errorReportValve.rootCause"));
                    sb.append("</b> <pre>");
                    sb.append(stackTrace);
                    sb.append("</pre></p>");
                    try {
                        rootCause = (Throwable)PropertyUtils.getProperty((Object)rootCause, (String)"rootCause");
                    }
                    catch (ClassCastException e) {
                        rootCause = null;
                    }
                    catch (IllegalAccessException e) {
                        rootCause = null;
                    }
                    catch (NoSuchMethodException e) {
                        rootCause = null;
                    }
                    catch (InvocationTargetException e) {
                        rootCause = null;
                    }
                }
                sb.append("<p><b>");
                sb.append(sm.getString("errorReportValve.note"));
                sb.append("</b> <u>");
                sb.append(sm.getString("errorReportValve.rootCauseInLogs"));
                sb.append("</u></p>");
            }
            sb.append("<HR size=\"1\" noshade>");
            sb.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
            sb.append("</body></html>");
            try {
                PrintWriter writer;
                block23: {
                    writer = response.getReporter();
                    if (writer == null) break block22;
                    Locale locale = Locale.getDefault();
                    try {
                        hres.setContentType("text/html");
                        hres.setLocale(locale);
                    }
                    catch (Throwable t) {
                        if (this.debug < 1) break block23;
                        this.log("status.setContentType", t);
                    }
                }
                ((Writer)writer).write(sb.toString());
            }
            catch (IOException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(this.toString() + ": " + message, throwable);
        } else {
            System.out.println(this.toString() + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

