/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class SetDocBaseRule
extends Rule {
    public SetDocBaseRule(Digester digester) {
        super(digester);
    }

    public void begin(Attributes attributes) throws Exception {
        File file;
        Context child = (Context)this.digester.peek(0);
        Deployer parent = (Deployer)this.digester.peek(1);
        Host host = null;
        if (!(parent instanceof StandardHost)) {
            Method method = parent.getClass().getMethod("getHost", null);
            host = (Host)method.invoke((Object)parent, null);
        } else {
            host = (Host)((Object)parent);
        }
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs();
        }
        if (!unpackWARs && !"true".equals(attributes.getValue("unpackWAR"))) {
            return;
        }
        if ("false".equals(attributes.getValue("unpackWAR"))) {
            return;
        }
        File canonicalAppBase = new File(appBase);
        canonicalAppBase = canonicalAppBase.isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        String docBase = child.getDocBase();
        if (docBase == null) {
            String path = child.getPath();
            if (path == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
        }
        if ((docBase = !(file = new File(docBase)).isAbsolute() ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath()).toLowerCase().endsWith(".war")) {
            URL war = new URL("jar:" + new File(docBase).toURL() + "!/");
            String contextPath = child.getPath();
            if (contextPath.equals("")) {
                contextPath = "ROOT";
            }
            docBase = ExpandWar.expand(host, war, contextPath);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
        } else {
            File warFile;
            File docDir = new File(docBase);
            if (!docDir.exists() && (warFile = new File(docBase + ".war")).exists()) {
                URL war = new URL("jar:" + warFile.toURL() + "!/");
                docBase = ExpandWar.expand(host, war, child.getPath());
                file = new File(docBase);
                docBase = file.getCanonicalPath();
            }
        }
        if (docBase.startsWith(canonicalAppBase.getPath())) {
            docBase = docBase.substring(canonicalAppBase.getPath().length() + 1);
        }
        docBase = docBase.replace(File.separatorChar, '/');
        child.setDocBase(docBase);
    }
}

