/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;

public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
MBeanRegistration {
    private static boolean first = true;
    private WebappClassLoader classLoader = null;
    private Container container = null;
    private int debug = 0;
    protected DefaultContext defaultContext = null;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.WebappClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private ArrayList loaderRepositories = null;
    private boolean initialized = false;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$loader$WebappLoader == null ? (class$org$apache$catalina$loader$WebappLoader = WebappLoader.class$("org.apache.catalina.loader.WebappLoader")) : class$org$apache$catalina$loader$WebappLoader));
    private ObjectName oname;
    private MBeanServer mserver;
    private String domain;
    private ObjectName controller;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$catalina$loader$WebappLoader;

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Integer(this.debug));
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", new Boolean(oldDelegate), new Boolean(this.delegate));
    }

    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", new Boolean(oldReloadable), new Boolean(this.reloadable));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addRepository(String repository) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.addRepository", repository));
        }
        for (int i = 0; i < this.repositories.length; ++i) {
            if (!repository.equals(this.repositories[i])) continue;
            return;
        }
        String[] results = new String[this.repositories.length + 1];
        for (int i = 0; i < this.repositories.length; ++i) {
            results[i] = this.repositories[i];
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            if (this.loaderRepositories != null) {
                this.loaderRepositories.add(repository);
            }
            this.setClassPath();
        }
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public String[] getRepositories() {
        return (String[])this.repositories.clone();
    }

    public String getRepositoriesString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.repositories.length; ++i) {
            sb.append(this.repositories[i]).append(":");
        }
        return sb.toString();
    }

    public String[] getLoaderRepositories() {
        if (this.loaderRepositories == null) {
            return null;
        }
        String[] res = new String[this.loaderRepositories.size()];
        this.loaderRepositories.toArray(res);
        return res;
    }

    public String getLoaderRepositoriesString() {
        String[] repositories = this.getLoaderRepositories();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < repositories.length; ++i) {
            sb.append(repositories[i]).append(":");
        }
        return sb.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    public boolean modified() {
        return this.classLoader.modified();
    }

    public void closeJARs(boolean force) {
        if (this.classLoader != null) {
            this.classLoader.closeJARs(force);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void init() {
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardContext) {
            try {
                StandardContext ctx = (StandardContext)this.container;
                Engine eng = (Engine)ctx.getParent().getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(ctx.getEngineName() + ":type=Loader,path=" + path + ",host=" + ctx.getParent().getName());
                Registry.getRegistry().registerComponent((Object)this, this.oname, null);
                this.controller = this.oname;
            }
            catch (Exception e) {
                log.error((Object)"Error registering loader", (Throwable)e);
            }
        }
        if (this.container == null) {
            // empty if block
        }
    }

    public void destroy() {
        if (this.controller == this.oname) {
            Registry.getRegistry().unregisterComponent(this.oname);
            this.oname = null;
        }
        this.initialized = false;
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("webappLoader.alreadyStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container.getResources() == null) {
            log.info((Object)("No resources for " + this.container));
            return;
        }
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        if (first) {
            first = false;
            try {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
            }
            catch (Exception e) {
                log.error((Object)"Error registering jndi stream handler", (Throwable)e);
            }
            catch (Throwable t) {
                log.info((Object)("Dual registration of jndi stream handler: " + t.getMessage()));
            }
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.container.getResources());
            this.classLoader.setDebug(this.debug);
            this.classLoader.setDelegate(this.delegate);
            for (int i = 0; i < this.repositories.length; ++i) {
                this.classLoader.addRepository(this.repositories[i]);
            }
            this.setRepositories();
            this.setClassPath();
            this.setPermissions();
            if (this.classLoader instanceof Lifecycle) {
                this.classLoader.start();
            }
            DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)this.container.getResources());
        }
        catch (Throwable t) {
            log.error((Object)"LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("webappLoader.notStarted"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            this.classLoader.stop();
        }
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        this.classLoader = null;
        this.destroy();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    private WebappClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoader classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        Class[] argTypes = new Class[]{class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = WebappLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoader)constr.newInstance(args);
        return classLoader;
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("WebappLoader[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("WebappLoader[" + this.container.getName() + "] " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("WebappLoader[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void setPermissions() {
        block20: {
            if (System.getSecurityManager() == null) {
                return;
            }
            if (!(this.container instanceof Context)) {
                return;
            }
            ServletContext servletContext = ((Context)this.container).getServletContext();
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                try {
                    String workDirPath = workDir.getCanonicalPath();
                    this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                    this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                String path;
                URL rootURL = servletContext.getResource("/");
                this.classLoader.addPermission(rootURL);
                String contextRoot = servletContext.getRealPath("/");
                if (contextRoot != null) {
                    try {
                        contextRoot = new File(contextRoot).getCanonicalPath();
                        this.classLoader.addPermission(contextRoot);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                URL classesURL = servletContext.getResource("/WEB-INF/classes/");
                this.classLoader.addPermission(classesURL);
                URL libURL = servletContext.getResource("/WEB-INF/lib/");
                this.classLoader.addPermission(libURL);
                if (contextRoot != null) {
                    if (libURL != null) {
                        File rootDir = new File(contextRoot);
                        File libDir = new File(rootDir, "WEB-INF/lib/");
                        try {
                            String path2 = libDir.getCanonicalPath();
                            this.classLoader.addPermission(path2);
                        }
                        catch (IOException e) {}
                    }
                    break block20;
                }
                if (workDir == null) break block20;
                if (libURL != null) {
                    File libDir = new File(workDir, "WEB-INF/lib/");
                    try {
                        path = libDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (classesURL != null) {
                    File classesDir = new File(workDir, "WEB-INF/classes/");
                    try {
                        path = classesDir.getCanonicalPath();
                        this.classLoader.addPermission(path);
                    }
                    catch (IOException e) {}
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private void setRepositories() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        this.loaderRepositories = new ArrayList();
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir == null) {
            log.info((Object)("No work dir for " + servletContext));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("webappLoader.deploy", workDir.getAbsolutePath()));
        }
        this.classLoader.setWorkDir(workDir);
        DirContext resources = this.container.getResources();
        String classesPath = "/WEB-INF/classes";
        DirContext classes = null;
        try {
            Object object = resources.lookup(classesPath);
            if (object instanceof DirContext) {
                classes = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (classes != null) {
            File classRepository = null;
            String absoluteClassesPath = servletContext.getRealPath(classesPath);
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, classesPath);
                classRepository.mkdirs();
                this.copyDir(classes, classRepository);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappLoader.classDeploy", classesPath, classRepository.getAbsolutePath()));
            }
            this.classLoader.addRepository(classesPath + "/", classRepository);
            this.loaderRepositories.add(classesPath + "/");
        }
        String libPath = "/WEB-INF/lib";
        this.classLoader.setJarPath(libPath);
        DirContext libDir = null;
        try {
            Object object = resources.lookup(libPath);
            if (object instanceof DirContext) {
                libDir = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (libDir != null) {
            boolean copyJars = false;
            String absoluteLibPath = servletContext.getRealPath(libPath);
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                destDir.mkdirs();
            }
            try {
                NamingEnumeration<Binding> namingEnumeration = resources.listBindings(libPath);
                while (namingEnumeration.hasMoreElements()) {
                    Binding binding = (Binding)namingEnumeration.nextElement();
                    String filename = libPath + "/" + binding.getName();
                    if (!filename.endsWith(".jar")) continue;
                    File destFile = new File(destDir, binding.getName());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("webappLoader.jarDeploy", filename, destFile.getAbsolutePath()));
                    }
                    Resource jarResource = (Resource)binding.getObject();
                    if (copyJars && !this.copy(jarResource.streamContent(), new FileOutputStream(destFile))) continue;
                    try {
                        JarFile jarFile = new JarFile(destFile);
                        this.classLoader.addJar(filename, jarFile, destFile);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.loaderRepositories.add(filename);
                }
            }
            catch (NamingException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setClassPath() {
        String baseClasspath;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        if (this.container instanceof StandardContext && (baseClasspath = ((StandardContext)this.container).getCompilerClasspath()) != null) {
            servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)baseClasspath);
            return;
        }
        StringBuffer classpath = new StringBuffer();
        ClassLoader loader = this.getClassLoader();
        int layers = 0;
        int n = 0;
        while (loader != null) {
            if (!(loader instanceof URLClassLoader)) {
                String cp = this.getClasspath(loader);
                if (cp == null) {
                    log.info((Object)("Unknown loader " + loader + " " + loader.getClass()));
                    break;
                }
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(cp);
                ++n;
                break;
            }
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring(7);
                } else if (repository.startsWith("file:")) {
                    repository = repository.substring(5);
                } else {
                    if (!repository.startsWith("jndi:")) continue;
                    repository = servletContext.getRealPath(repository.substring(5));
                }
                if (repository == null) continue;
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
                ++n;
            }
            loader = loader.getParent();
            ++layers;
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    private String getClasspath(ClassLoader loader) {
        try {
            Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
            if (log.isTraceEnabled()) {
                log.trace((Object)("getClasspath " + m));
            }
            if (m == null) {
                return null;
            }
            Object o = m.invoke((Object)loader, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("gotClasspath " + o));
            }
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getClasspath ", (Throwable)ex);
            }
            return null;
        }
    }

    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = srcDir.list("");
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                currentFile.mkdir();
                this.copyDir((DirContext)object, currentFile);
            }
        }
        catch (NamingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

