/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardValveContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$core$StandardPipeline == null ? (class$org$apache$catalina$core$StandardPipeline = StandardPipeline.class$("org.apache.catalina.core.StandardPipeline")) : class$org$apache$catalina$core$StandardPipeline));
    protected Valve basic = null;
    protected Container container = null;
    protected int debug = 0;
    protected String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected Valve[] valves = new Valve[0];
    static /* synthetic */ Class class$org$apache$catalina$core$StandardPipeline;

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return this.info;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        for (int i = 0; i < this.valves.length; ++i) {
            if (this.valves[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[i])).start();
            }
            this.registerValve(this.valves[i]);
        }
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).start();
        }
        if (this.basic != null) {
            this.registerValve(this.basic);
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).stop();
        }
        if (this.basic != null) {
            this.unregisterValve(this.basic);
        }
        for (int i = 0; i < this.valves.length; ++i) {
            if (this.valves[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[i])).stop();
            }
            this.unregisterValve(this.valves[i]);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    private void registerValve(Valve valve) {
        if (valve instanceof ValveBase && ((ValveBase)valve).getObjectName() == null) {
            try {
                ObjectName vname;
                String domain = ((ContainerBase)this.container).getDomain();
                if (this.container instanceof StandardContext) {
                    domain = ((StandardContext)this.container).getEngineName();
                }
                if (this.container instanceof StandardWrapper) {
                    Container ctx = ((StandardWrapper)this.container).getParent();
                    domain = ((StandardContext)ctx).getEngineName();
                }
                if ((vname = ((ValveBase)valve).createObjectName(domain, ((ContainerBase)this.container).getJmxName())) != null) {
                    ((ValveBase)valve).setObjectName(vname);
                    Registry.getRegistry().registerComponent((Object)valve, vname, valve.getClass().getName());
                    ((ValveBase)valve).setController(((ContainerBase)this.container).getJmxName());
                }
            }
            catch (Throwable t) {
                log.info((Object)("Can't register valve " + valve), t);
            }
        }
    }

    private void unregisterValve(Valve valve) {
        if (valve instanceof ValveBase) {
            try {
                ValveBase vb = (ValveBase)valve;
                if (vb.getController() != null && vb.getController() == ((ContainerBase)this.container).getJmxName()) {
                    ObjectName vname = vb.getObjectName();
                    Registry.getRegistry().getMBeanServer().unregisterMBean(vname);
                    ((ValveBase)valve).setObjectName(null);
                }
            }
            catch (Throwable t) {
                log.info((Object)("Can't unregister valve " + valve), t);
            }
        }
    }

    public Valve getBasic() {
        return this.basic;
    }

    public void setBasic(Valve valve) {
        Valve oldBasic = this.basic;
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            if (this.started && oldBasic instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldBasic)).stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"StandardPipeline.setBasic: stop", (Throwable)e);
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"StandardPipeline.setBasic: start", (Throwable)e);
                return;
            }
        }
        this.basic = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started) {
            if (valve instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)valve)).start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"StandardPipeline.addValve: start: ", (Throwable)e);
                }
            }
            this.registerValve(valve);
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valve[] getValves() {
        if (this.basic == null) {
            return this.valves;
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = this.basic;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return results;
        }
    }

    public ObjectName[] getValveObjectNames() {
        ObjectName[] oname = new ObjectName[this.valves.length + 1];
        for (int i = 0; i < this.valves.length; ++i) {
            if (!(this.valves[i] instanceof ValveBase)) continue;
            oname[i] = ((ValveBase)this.valves[i]).getObjectName();
        }
        if (this.basic instanceof ValveBase) {
            oname[this.valves.length] = ((ValveBase)this.basic).getObjectName();
        }
        return oname;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        StandardValveContext valveContext = (StandardValveContext)request.getValveContext();
        if (valveContext == null) {
            valveContext = new StandardValveContext();
            request.setValveContext(valveContext);
        }
        valveContext.set(this.basic, this.valves);
        valveContext.invokeNext(request, response);
        valveContext.set(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            int j = -1;
            for (int i = 0; i < this.valves.length; ++i) {
                if (valve != this.valves[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Valve[] results = new Valve[this.valves.length - 1];
            int n = 0;
            for (int i = 0; i < this.valves.length; ++i) {
                if (i == j) continue;
                results[n++] = this.valves[i];
            }
            this.valves = results;
            try {
                if (valve instanceof Contained) {
                    ((Contained)((Object)valve)).setContainer(null);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.started) {
                if (valve instanceof Lifecycle) {
                    try {
                        ((Lifecycle)((Object)valve)).stop();
                    }
                    catch (LifecycleException e) {
                        log.error((Object)"StandardPipeline.removeValve: stop: ", (Throwable)e);
                    }
                }
                this.unregisterValve(valve);
            }
            return;
        }
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message, throwable);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

