/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.catalina.core.ApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ApplicationContextFacade
implements ServletContext {
    private HashMap classCache;
    private HashMap objectCache;
    private static Log sysLog = LogFactory.getLog((Class)(class$org$apache$catalina$core$ApplicationContextFacade == null ? (class$org$apache$catalina$core$ApplicationContextFacade = ApplicationContextFacade.class$("org.apache.catalina.core.ApplicationContextFacade")) : class$org$apache$catalina$core$ApplicationContextFacade));
    private ApplicationContext context = null;
    static /* synthetic */ Class class$org$apache$catalina$core$ApplicationContextFacade;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;

    public ApplicationContextFacade(ApplicationContext context) {
        this.context = context;
        this.classCache = new HashMap();
        this.objectCache = new HashMap();
        this.initClassCache();
    }

    private void initClassCache() {
        Class[] clazz = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ApplicationContextFacade.class$("java.lang.String")) : class$java$lang$String};
        this.classCache.put("getContext", clazz);
        this.classCache.put("getMimeType", clazz);
        this.classCache.put("getResourcePaths", clazz);
        this.classCache.put("getResource", clazz);
        this.classCache.put("getResourceAsStream", clazz);
        this.classCache.put("getRequestDispatcher", clazz);
        this.classCache.put("getNamedDispatcher", clazz);
        this.classCache.put("getServlet", clazz);
        this.classCache.put("getInitParameter", clazz);
        this.classCache.put("setAttribute", new Class[]{class$java$lang$String == null ? (class$java$lang$String = ApplicationContextFacade.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = ApplicationContextFacade.class$("java.lang.Object")) : class$java$lang$Object});
        this.classCache.put("removeAttribute", clazz);
        this.classCache.put("getRealPath", clazz);
        this.classCache.put("getAttribute", clazz);
        this.classCache.put("log", clazz);
    }

    public ServletContext getContext(String uripath) {
        ServletContext theContext = null;
        theContext = System.getSecurityManager() != null ? (ServletContext)this.doPrivileged("getContext", new Object[]{uripath}) : this.context.getContext(uripath);
        if (theContext != null && theContext instanceof ApplicationContext) {
            theContext = ((ApplicationContext)theContext).getFacade();
        }
        return theContext;
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public String getMimeType(String file) {
        if (System.getSecurityManager() != null) {
            return (String)this.doPrivileged("getMimeType", new Object[]{file});
        }
        return this.context.getMimeType(file);
    }

    public Set getResourcePaths(String path) {
        if (System.getSecurityManager() != null) {
            return (Set)this.doPrivileged("getResourcePaths", new Object[]{path});
        }
        return this.context.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (System.getSecurityManager() != null) {
            try {
                return (URL)this.invokeMethod(this.context, "getResource", new Object[]{path});
            }
            catch (Throwable t) {
                if (t instanceof MalformedURLException) {
                    throw (MalformedURLException)t;
                }
                return null;
            }
        }
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (System.getSecurityManager() != null) {
            return (InputStream)this.doPrivileged("getResourceAsStream", new Object[]{path});
        }
        return this.context.getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (System.getSecurityManager() != null) {
            return (RequestDispatcher)this.doPrivileged("getRequestDispatcher", new Object[]{path});
        }
        return this.context.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (System.getSecurityManager() != null) {
            return (RequestDispatcher)this.doPrivileged("getNamedDispatcher", new Object[]{name});
        }
        return this.context.getNamedDispatcher(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        if (System.getSecurityManager() != null) {
            try {
                return (Servlet)this.invokeMethod(this.context, "getServlet", new Object[]{name});
            }
            catch (Throwable t) {
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                return null;
            }
        }
        return this.context.getServlet(name);
    }

    public Enumeration getServlets() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)this.doPrivileged("getServlets", null);
        }
        return this.context.getServlets();
    }

    public Enumeration getServletNames() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)this.doPrivileged("getServletNames", null);
        }
        return this.context.getServletNames();
    }

    public void log(String msg) {
        if (System.getSecurityManager() != null) {
            this.doPrivileged("log", new Object[]{msg});
        } else {
            this.context.log(msg);
        }
    }

    public void log(Exception exception, String msg) {
        if (System.getSecurityManager() != null) {
            this.doPrivileged("log", new Class[]{class$java$lang$Exception == null ? (class$java$lang$Exception = ApplicationContextFacade.class$("java.lang.Exception")) : class$java$lang$Exception, class$java$lang$String == null ? (class$java$lang$String = ApplicationContextFacade.class$("java.lang.String")) : class$java$lang$String}, new Object[]{exception, msg});
        } else {
            this.context.log(exception, msg);
        }
    }

    public void log(String message, Throwable throwable) {
        if (System.getSecurityManager() != null) {
            this.doPrivileged("log", new Class[]{class$java$lang$String == null ? (class$java$lang$String = ApplicationContextFacade.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = ApplicationContextFacade.class$("java.lang.Throwable")) : class$java$lang$Throwable}, new Object[]{message, throwable});
        } else {
            this.context.log(message, throwable);
        }
    }

    public String getRealPath(String path) {
        if (System.getSecurityManager() != null) {
            return (String)this.doPrivileged("getRealPath", new Object[]{path});
        }
        return this.context.getRealPath(path);
    }

    public String getServerInfo() {
        if (System.getSecurityManager() != null) {
            return (String)this.doPrivileged("getServerInfo", null);
        }
        return this.context.getServerInfo();
    }

    public String getInitParameter(String name) {
        if (System.getSecurityManager() != null) {
            return (String)this.doPrivileged("getInitParameter", new Object[]{name});
        }
        return this.context.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)this.doPrivileged("getInitParameterNames", null);
        }
        return this.context.getInitParameterNames();
    }

    public Object getAttribute(String name) {
        if (System.getSecurityManager() != null) {
            return this.doPrivileged("getAttribute", new Object[]{name});
        }
        return this.context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)this.doPrivileged("getAttributeNames", null);
        }
        return this.context.getAttributeNames();
    }

    public void setAttribute(String name, Object object) {
        if (System.getSecurityManager() != null) {
            this.doPrivileged("setAttribute", new Object[]{name, object});
        } else {
            this.context.setAttribute(name, object);
        }
    }

    public void removeAttribute(String name) {
        if (System.getSecurityManager() != null) {
            this.doPrivileged("removeAttribute", new Object[]{name});
        } else {
            this.context.removeAttribute(name);
        }
    }

    public String getServletContextName() {
        if (System.getSecurityManager() != null) {
            return (String)this.doPrivileged("getServletContextName", null);
        }
        return this.context.getServletContextName();
    }

    private Object doPrivileged(ApplicationContext appContext, String methodName, Object[] params) {
        try {
            return this.invokeMethod(appContext, methodName, params);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private Object doPrivileged(String methodName, Object[] params) {
        try {
            return this.invokeMethod(this.context, methodName, params);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private Object invokeMethod(ApplicationContext appContext, String methodName, Object[] params) throws Throwable {
        try {
            Method method = (Method)this.objectCache.get(methodName);
            if (method == null) {
                method = appContext.getClass().getMethod(methodName, (Class[])this.classCache.get(methodName));
                this.objectCache.put(methodName, method);
            }
            return this.executeMethod(method, appContext, params);
        }
        catch (Exception ex) {
            this.handleException(ex, methodName);
            return null;
        }
    }

    private Object doPrivileged(String methodName, Class[] clazz, Object[] params) {
        try {
            Method method = this.context.getClass().getMethod(methodName, clazz);
            return this.executeMethod(method, this.context, params);
        }
        catch (Exception ex) {
            try {
                this.handleException(ex, methodName);
            }
            catch (Throwable t) {
                throw new RuntimeException(t.getMessage());
            }
            return null;
        }
    }

    private Object executeMethod(final Method method, final ApplicationContext context, final Object[] params) throws PrivilegedActionException, IllegalAccessException, InvocationTargetException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    return method.invoke((Object)context, params);
                }
            });
        }
        return method.invoke((Object)context, params);
    }

    private void handleException(Exception ex, String methodName) throws Throwable {
        if (sysLog.isDebugEnabled()) {
            sysLog.debug((Object)("ApplicationContextFacade." + methodName), (Throwable)ex);
        }
        if (ex instanceof PrivilegedActionException) {
            ex = ((PrivilegedActionException)ex).getException();
        }
        Throwable realException = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getTargetException() : ex;
        throw realException;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

