/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.util;

import java.util.HashMap;
import java.util.LinkedList;

public class SmartQueue {
    private LinkedList queue = new LinkedList();
    private HashMap queueMap = new HashMap();
    private Object mutex = new Object();
    public static int debug = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SmartEntry entry) {
        Object object = this.mutex;
        synchronized (object) {
            SmartEntry current = (SmartEntry)this.queueMap.get(entry.getKey());
            if (current == null) {
                if (debug != 0) {
                    System.out.println("[" + Thread.currentThread().getName() + "][SmartQueue] Adding new object=" + entry);
                }
                this.queue.addLast(entry);
                this.queueMap.put(entry.getKey(), entry);
            } else {
                if (debug != 0) {
                    System.out.print("[" + Thread.currentThread().getName() + "][SmartQueue] Replacing old object=" + current);
                }
                current.setValue(entry.getValue());
                if (debug != 0) {
                    System.out.println("with new object=" + current);
                }
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SmartEntry remove() {
        SmartEntry result = null;
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                if (this.size() != 0) {
                    result = (SmartEntry)this.queue.removeFirst();
                    this.queueMap.remove(result.getKey());
                    if (debug == 0) return result;
                    System.out.println("[" + Thread.currentThread().getName() + "][SmartQueue] Returning=" + result);
                    return result;
                }
                try {
                    if (debug != 0) {
                        System.out.println("[" + Thread.currentThread().getName() + "][SmartQueue] Queue sleeping until object added size=" + this.size() + ".");
                    }
                    this.mutex.wait();
                    if (debug == 0) continue;
                    System.out.println("[" + Thread.currentThread().getName() + "][SmartQueue] Queue woke up or interrupted size=" + this.size() + ".");
                    continue;
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static class SmartEntry {
        protected Object key;
        protected Object value;

        public SmartEntry(Object key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("SmartEntry key can not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("SmartEntry value can not be null.");
            }
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("SmartEntry value can not be null.");
            }
            this.value = value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof SmartEntry)) {
                return false;
            }
            SmartEntry other = (SmartEntry)o;
            return other.getKey().equals(this.getKey());
        }

        public String toString() {
            return "[SmartyEntry key=" + this.key + " value=" + this.value + "]";
        }
    }
}

