/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.catalina.cluster.tcp.IDataSender;

public class SocketSender
implements IDataSender {
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = false;
    private boolean suspect;

    public SocketSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws IOException {
        this.sc = new Socket(this.getAddress(), this.getPort());
        this.isSocketConnected = true;
    }

    public void disconnect() {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isSocketConnected = false;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    public synchronized void sendMessage(String sessionId, byte[] data) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.sc.getOutputStream().write(data);
        }
        catch (IOException x) {
            this.disconnect();
            this.connect();
            this.sc.getOutputStream().write(data);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }
}

