/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;

public class SerializablePrincipal
implements Serializable {
    protected String name = null;
    protected String password = null;
    protected transient Realm realm = null;
    protected String[] roles = new String[0];

    public SerializablePrincipal() {
    }

    public SerializablePrincipal(Realm realm, String name, String password) {
        this(realm, name, password, null);
    }

    public SerializablePrincipal(Realm realm, String name, String password, List roles) {
        this.realm = realm;
        this.name = name;
        this.password = password;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SerializablePrincipal[");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    public static SerializablePrincipal createPrincipal(GenericPrincipal principal) {
        if (principal == null) {
            return null;
        }
        return new SerializablePrincipal(principal.getRealm(), principal.getName(), principal.getPassword(), principal.getRoles() != null ? Arrays.asList(principal.getRoles()) : null);
    }

    public GenericPrincipal getPrincipal(Realm realm) {
        return new GenericPrincipal(realm, this.name, this.password, this.getRoles() != null ? Arrays.asList(this.getRoles()) : null);
    }
}

